/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.URL;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.maven2.AbstractCargoMojo;
import org.codehaus.cargo.maven2.configuration.Deployable;

public abstract class AbstractDeployerMojo
extends AbstractCargoMojo {
    public void doExecute() throws MojoExecutionException {
        if (!(this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() || this.getDeployerElement() != null && this.getDeployerElement().getDeployables() != null && this.getDeployerElement().getDeployables().length != 0)) {
            this.getLog().info((CharSequence)"There's nothing to deploy or undeploy");
            return;
        }
        Container container = this.createContainer();
        Deployer deployer = this.createDeployer(container);
        this.performDeployerActionOnAllDeployables(container, deployer);
    }

    protected Deployer createDeployer(Container container) throws MojoExecutionException {
        Deployer deployer = this.getDeployerElement() == null ? this.createDeployerFactory().createDeployer(container) : this.getDeployerElement().createDeployer(container);
        return deployer;
    }

    protected DeployerFactory createDeployerFactory() {
        return new DefaultDeployerFactory();
    }

    private void performDeployerActionOnAllDeployables(Container container, Deployer deployer) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Performing deployment action into [" + container.getName() + "]..."));
        ArrayList<Deployable> deployableElements = new ArrayList<Deployable>();
        if (this.getDeployerElement() != null && this.getDeployerElement().getDeployables() != null) {
            for (Deployable deployableElement : this.getDeployerElement().getDeployables()) {
                deployableElements.add(deployableElement);
            }
        }
        if (this.getConfigurationElement() != null && this.getConfigurationElement().getDeployables() != null) {
            for (Deployable deployableElement : this.getConfigurationElement().getDeployables()) {
                if (deployableElements.contains(deployableElement)) continue;
                deployableElements.add(deployableElement);
            }
        }
        for (Deployable deployableElement : deployableElements) {
            org.codehaus.cargo.container.deployable.Deployable deployable = deployableElement.createDeployable(container.getId(), this.getCargoProject());
            URL pingURL = deployableElement.getPingURL();
            Long pingTimeout = deployableElement.getPingTimeout();
            this.performDeployerActionOnSingleDeployable(deployer, deployable, pingURL, pingTimeout);
        }
        if (this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging()) {
            Deployable[] deployableElementsArray = new Deployable[deployableElements.size()];
            deployableElements.toArray(deployableElementsArray);
            if (!this.containsAutoDeployable(deployableElementsArray)) {
                this.performDeployerActionOnSingleDeployable(deployer, this.createAutoDeployDeployable(container), null, null);
            }
        }
    }

    protected abstract void performDeployerActionOnSingleDeployable(Deployer var1, org.codehaus.cargo.container.deployable.Deployable var2, URL var3, Long var4);

    protected DeployableMonitor createDeployableMonitor(URL pingURL, Long pingTimeout, org.codehaus.cargo.container.deployable.Deployable deployable) {
        URLDeployableMonitor monitor = pingTimeout == null ? new URLDeployableMonitor(pingURL) : new URLDeployableMonitor(pingURL, pingTimeout.longValue());
        DeployerListener listener = new DeployerListener(deployable);
        monitor.registerListener((DeployableMonitorListener)listener);
        return monitor;
    }

    public class DeployerListener
    implements DeployableMonitorListener {
        private org.codehaus.cargo.container.deployable.Deployable deployable;

        public DeployerListener(org.codehaus.cargo.container.deployable.Deployable deployable) {
            this.deployable = deployable;
        }

        public void deployed() {
            AbstractDeployerMojo.this.getLog().debug((CharSequence)("Watchdog finds [" + this.deployable.getFile() + "] deployed."));
        }

        public void undeployed() {
            AbstractDeployerMojo.this.getLog().debug((CharSequence)("Watchdog finds [" + this.deployable.getFile() + "] not deployed yet."));
        }
    }
}

