/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import jsr166y.forkjoin.ForkJoinTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LinkedAsyncAction
extends ForkJoinTask<Void> {
    private LinkedAsyncAction parent;
    private volatile int pendingCount;
    private static final AtomicIntegerFieldUpdater<LinkedAsyncAction> pendingCountUpdater = AtomicIntegerFieldUpdater.newUpdater(LinkedAsyncAction.class, "pendingCount");

    protected LinkedAsyncAction() {
    }

    protected LinkedAsyncAction(LinkedAsyncAction parent) {
        this.parent = parent;
        if (parent != null) {
            pendingCountUpdater.incrementAndGet(parent);
        }
    }

    protected LinkedAsyncAction(LinkedAsyncAction parent, boolean register) {
        this.parent = parent;
        if (parent != null && register) {
            pendingCountUpdater.incrementAndGet(parent);
        }
    }

    protected LinkedAsyncAction(LinkedAsyncAction parent, boolean register, int pending) {
        this.parent = parent;
        this.pendingCount = pending;
        if (parent != null && register) {
            pendingCountUpdater.incrementAndGet(parent);
        }
    }

    protected abstract void compute();

    protected void onCompletion() {
    }

    protected boolean onException() {
        return true;
    }

    public final void finish() {
        this.finish(null);
    }

    @Override
    public final void finish(Void result) {
        LinkedAsyncAction a = this;
        while (a != null && !a.isDone()) {
            int c = a.pendingCount;
            if (c == 0) {
                try {
                    a.onCompletion();
                }
                catch (Throwable rex) {
                    a.finishExceptionally(rex);
                    return;
                }
                a.setDone();
                a = a.parent;
                continue;
            }
            if (!pendingCountUpdater.compareAndSet(a, c, c - 1)) continue;
            return;
        }
    }

    @Override
    public final void finishExceptionally(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        LinkedAsyncAction a = this;
        while (a.setDoneExceptionally(ex) == ex) {
            boolean up = a.onException();
            a = a.parent;
            if (a == null) {
                return;
            }
            if (up) continue;
            a.finish();
            return;
        }
    }

    public final LinkedAsyncAction getParent() {
        return this.parent;
    }

    public final int getPendingSubtaskCount() {
        return this.pendingCount;
    }

    @Override
    public final Void rawResult() {
        return null;
    }

    @Override
    public void reinitialize() {
        super.reinitialize();
        if (this.pendingCount != 0) {
            this.pendingCount = 0;
        }
    }

    public void reinitialize(int pending) {
        super.reinitialize();
        this.pendingCount = pending;
    }

    public void reinitialize(LinkedAsyncAction parent, boolean register) {
        super.reinitialize();
        if (this.pendingCount != 0) {
            this.pendingCount = 0;
        }
        this.parent = parent;
        if (parent != null && register) {
            pendingCountUpdater.incrementAndGet(parent);
        }
    }

    public void reinitialize(LinkedAsyncAction parent, boolean register, int pending) {
        super.reinitialize();
        this.pendingCount = pending;
        this.parent = parent;
        if (parent != null && register) {
            pendingCountUpdater.incrementAndGet(parent);
        }
    }

    @Override
    public final Void forkJoin() {
        this.exec();
        return (Void)this.join();
    }

    @Override
    public final Throwable exec() {
        if (this.exception == null) {
            try {
                this.compute();
            }
            catch (Throwable rex) {
                this.finishExceptionally(rex);
            }
        }
        return this.exception;
    }
}

