/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.managers;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.chorem.vradi.VradiTestAbstract;
import org.chorem.vradi.entities.WebHarvestStream;
import org.chorem.vradi.entities.WebHarvestStreamImpl;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.entities.XmlStreamImpl;
import org.chorem.vradi.services.managers.BindingManager;
import org.junit.Before;
import org.junit.Test;

public class BindingManagerTest
extends VradiTestAbstract {
    protected BindingManager bindingManager;

    @Before
    public void initBindingManager() {
        this.bindingManager = new BindingManager(this.config, this.wikittyProxy, null, null);
    }

    @Test
    public void testGetAllXmlStreams() {
        XmlStreamImpl xmlStreamEquipe = new XmlStreamImpl();
        xmlStreamEquipe.setName("equipe.fr");
        XmlStreamImpl xmlStreamDalinux = new XmlStreamImpl();
        xmlStreamDalinux.setName("dalinux");
        WebHarvestStreamImpl xmlStreamOuestFrance = new WebHarvestStreamImpl();
        xmlStreamOuestFrance.setName("xmlStreamOuestFrance");
        ArrayList<Object> xmlStreams = new ArrayList<Object>();
        xmlStreams.add(xmlStreamEquipe);
        xmlStreams.add(xmlStreamDalinux);
        xmlStreams.add(xmlStreamOuestFrance);
        this.wikittyProxy.store(xmlStreams);
        List xmlStreamsRestored = this.bindingManager.getAllXmlStreams();
        Assert.assertEquals((int)3, (int)xmlStreamsRestored.size());
        int count = 0;
        for (XmlStream xmlStream : xmlStreamsRestored) {
            if (xmlStream.getName().equals("equipe.fr")) {
                Assert.assertTrue((boolean)(xmlStream instanceof XmlStream));
                ++count;
                continue;
            }
            if (xmlStream.getName().equals("dalinux")) {
                Assert.assertTrue((boolean)(xmlStream instanceof XmlStream));
                ++count;
                continue;
            }
            if (!xmlStream.getName().equals("xmlStreamOuestFrance")) continue;
            Assert.assertTrue((boolean)(xmlStream instanceof WebHarvestStream));
            ++count;
        }
        Assert.assertEquals((int)3, (int)count);
    }

    @Test
    public void testGetAllWebHarvestStreams() {
        XmlStreamImpl xmlStreamEquipe = new XmlStreamImpl();
        xmlStreamEquipe.setName("equipe.fr");
        XmlStreamImpl xmlStreamDalinux = new XmlStreamImpl();
        xmlStreamDalinux.setName("dalinux");
        WebHarvestStreamImpl xmlStreamOuestFrance = new WebHarvestStreamImpl();
        xmlStreamOuestFrance.setName("xmlStreamOuestFrance");
        ArrayList<Object> xmlStreams = new ArrayList<Object>();
        xmlStreams.add(xmlStreamEquipe);
        xmlStreams.add(xmlStreamDalinux);
        xmlStreams.add(xmlStreamOuestFrance);
        this.wikittyProxy.store(xmlStreams);
        List xmlStreamsRestored = this.bindingManager.getAllWebHarvestStreams();
        Assert.assertEquals((int)1, (int)xmlStreamsRestored.size());
        for (WebHarvestStream xmlStream : xmlStreamsRestored) {
            if (!xmlStream.getName().equals("xmlStreamOuestFrance")) continue;
            Assert.assertTrue((boolean)(xmlStream instanceof WebHarvestStream));
        }
    }
}

