/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: XmlStreamImportResult.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/beans/XmlStreamImportResult.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.vradi.beans;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * Import xml stream results.
 * <p/>
 * Contains :
 * - the number of created forms
 * - the number of already existing forms (non created)
 * - the number of forms created with date parsing error
 * - the number of forms created with number parsing error
 *
 * @author chatellier
 * @version $Revision: 21 $
 *          <p/>
 *          Last update : $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 *          By : $Author: sletellier $
 */
public class XmlStreamImportResult implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7378576743532050958L;

    protected int createdFormCount;

    protected int alreadyExistsFormCount;

    protected int dateParsingError;

    protected int numberParsingError;

    protected Set<String> createdFormsIds;

    public int getCreatedFormCount() {
        return createdFormCount;
    }

    public void setCreatedFormCount(int createdFormCount) {
        this.createdFormCount = createdFormCount;
    }

    public int getAlreadyExistsFormCount() {
        return alreadyExistsFormCount;
    }

    public void setAlreadyExistsFormCount(int alreadyExistsFormCount) {
        this.alreadyExistsFormCount = alreadyExistsFormCount;
    }

    public int getDateParsingError() {
        return dateParsingError;
    }

    public void setDateParsingError(int dateParsingError) {
        this.dateParsingError = dateParsingError;
    }

    public int getNumberParsingError() {
        return numberParsingError;
    }

    public void setNumberParsingError(int numberParsingError) {
        this.numberParsingError = numberParsingError;
    }

    public Set<String> getCreatedFormsIds() {
        return createdFormsIds;
    }

    public void setCreatedFormsIds(Set<String> createdFormsIds) {
        this.createdFormsIds = createdFormsIds;
    }

    public void addCreatedFormsIds(String wikittyId) {
        if (createdFormsIds == null) {
            createdFormsIds = new HashSet<String>();
        }
        createdFormsIds.add(wikittyId);
    }
}
