/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.cumulative;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.InvalidVoteCountingConfig;
import org.chorem.pollen.votecounting.api.VoteCountingErrorIssue;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.api.model.PollenError;
import org.chorem.pollen.votecounting.api.model.PollenErrorIssue;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.impl.cumulative.CumulativeConfig;
import org.chorem.pollen.votecounting.impl.cumulative.CumulativeErrorIssue;
import org.chorem.pollen.votecounting.impl.cumulative.CumulativeVoteCountingStrategy;

public class CumulativeVoteCounting
extends AbstractVoteCounting {
    public CumulativeVoteCounting() {
        super(VoteCountings.Cumulative);
    }

    public CumulativeVoteCountingStrategy newStrategy() {
        return new CumulativeVoteCountingStrategy();
    }

    @Override
    public CumulativeConfig createConfig() {
        return new CumulativeConfig();
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public Optional<Double> getMinimumValue() {
        return Optional.of(0.0);
    }

    @Override
    public List<PollenError> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        List<PollenError> errors = super.validateVoteForChoice(voteForChoice, config, locale);
        CumulativeConfig cumulativeConfig = InvalidVoteCountingConfig.castVoteCountingConfigOrFail(config, CumulativeConfig.class);
        Double voteValue = voteForChoice.getVoteValue();
        if (voteValue != null) {
            if (voteValue < 0.0) {
                errors.add(new PollenError("voteValue", (PollenErrorIssue)VoteCountingErrorIssue.VOTE_VALUE_POSITIVE, (Object)voteValue, voteValue));
            } else if (voteValue > (double)cumulativeConfig.getPoints()) {
                errors.add(new PollenError("voteValue", (PollenErrorIssue)CumulativeErrorIssue.VOTE_VALUE_MAX, (Object)voteValue, voteValue, cumulativeConfig.getPoints()));
            }
        }
        return errors;
    }

    @Override
    public List<PollenError> validateVote(Voter vote, VoteCountingConfig config, Locale locale) {
        CumulativeConfig cumulativeConfig;
        List<PollenError> errors = super.validateVote(vote, config, locale);
        double totalValues = vote.getVoteForChoices().stream().mapToDouble(VoteForChoice::getVoteValue).filter(Objects::nonNull).sum();
        if (totalValues != (double)(cumulativeConfig = InvalidVoteCountingConfig.castVoteCountingConfigOrFail(config, CumulativeConfig.class)).getPoints()) {
            errors.add(new PollenError("totalValues", (PollenErrorIssue)CumulativeErrorIssue.VOTE_VALUES_TOTAL, (Object)totalValues, totalValues, cumulativeConfig.getPoints()));
        }
        return errors;
    }
}

