/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: GetInvitedPolls.java 3386 2012-05-24 18:13:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetInvitedPolls.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.nuiton.util.beans.Binder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Obtain invited polls to put in grid for the connected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetInvitedPolls extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] polls;

    public Map<String, Object>[] getPolls() {
        return polls;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        PollService pollService = newService(PollService.class);

        List<Pair<Poll, PollAccount>> invitedPolls = pollService.getInvitedPolls(pager,
                                                                                 getPollenUserAccount());

        polls = new Map[invitedPolls.size()];
        Binder<Poll, Poll> binder =
                PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Pair<Poll, PollAccount> entry : invitedPolls) {

            Poll poll = entry.getKey();
            Map<String, Object> map = pollService.pollToMap(poll, binder);
//            Map<String, Object> map = binder.obtainProperties(
//                    poll,
//                    Poll.PROPERTY_TITLE,
//                    Poll.PROPERTY_POLL_ID,
//                    Poll.PROPERTY_DESCRIPTION,
//                    Poll.PROPERTY_BEGIN_DATE,
//                    Poll.PROPERTY_END_DATE
//            );

            PollAccount account = entry.getValue();

            PollUri pollUri = PollUri.newPollUri(poll.getPollId(),
                                                 account.getAccountId());

//            map.put("id", poll.getTopiaId());
            map.put("voteId", pollUri.getUri());
            map.put("resultId", pollUri.getUri());

            Set<String> functions = getPollFunctions(poll);
            map.put("functions", functions);
            polls[index++] = map;
        }
        return SUCCESS;
    }

    protected Set<String> getPollFunctions(Poll poll) {
        Set<String> result = Sets.newHashSet();
        result.add("vote");
        if (poll.isPublicResults()) {

            // only if results are public
            result.add("result");
        }
        return result;
    }
}