/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.ResourceType;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.UnitHuman;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.resource.AbstractResourceBean;
import org.chorem.pollen.services.bean.resource.GtuMetaBean;
import org.chorem.pollen.services.bean.resource.ResourceFileBean;
import org.chorem.pollen.services.bean.resource.ResourceMetaBean;
import org.chorem.pollen.services.bean.resource.ResourceStreamBean;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenErrors;
import org.chorem.pollen.services.service.PollenServiceErrorIssue;
import org.chorem.pollen.services.service.PollenServiceSupport;

public class PollenResourceService
extends PollenServiceSupport
implements PollenService {
    public ResourceStreamBean toResourceStreamBean(PollenResource entity) {
        ResourceStreamBean bean = new ResourceStreamBean();
        bean.setEntityId(entity.getTopiaId());
        try (InputStream bdStream = entity.getResourceContent().getBinaryStream();){
            InputStream inMemoryStream = this.toMemoryInputStream(bdStream);
            bean.setResourceContent(inMemoryStream);
        }
        catch (IOException | SQLException e) {
            throw new PollenTechnicalException(e);
        }
        bean.setName(entity.getName());
        bean.setSize(entity.getSize());
        bean.setContentType(entity.getContentType());
        return bean;
    }

    private InputStream toMemoryInputStream(InputStream source) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)source, (OutputStream)byteArrayOutputStream);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
    }

    public ResourceMetaBean toResourceMetaBean(PollenResource entity) {
        GtuMetaBean bean = new GtuMetaBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setName(entity.getName());
        bean.setSize(entity.getSize());
        bean.setContentType(entity.getContentType());
        bean.setResourceType(entity.getResourceType());
        bean.setUploadDate(entity.getTopiaCreateDate());
        return bean;
    }

    public ResourceStreamBean getResource(PollenEntityId<PollenResource> resourceId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(resourceId);
        PollenResource resource = this.getResource0(resourceId);
        return this.toResourceStreamBean(resource);
    }

    public ResourceMetaBean getMetaResource(PollenEntityId<PollenResource> resourceId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(resourceId);
        PollenResource resource = this.getResource0(resourceId);
        return this.toResourceMetaBean(resource);
    }

    public ResourceStreamBean getResourcePreview(PollenEntityId<PollenResource> resourceId, boolean maxDimension) {
        this.checkIsConnectedRequired();
        this.checkNotNull(resourceId);
        PollenResource resource = this.getResource0(resourceId);
        try {
            int previewHeight;
            int previewWidth;
            int height;
            int width;
            String contentType;
            BufferedImage source;
            if (resource.getContentType().matches("image/(jpeg|png|gif)")) {
                source = ImageIO.read(resource.getResourceContent().getBinaryStream());
                contentType = resource.getContentType();
            } else {
                source = ImageIO.read(PollenResourceService.class.getResourceAsStream("/default.jpg"));
                contentType = "image/jpeg";
            }
            int previewMax = this.getPollenServiceConfig().getResourcePreviewMax();
            if (source.getWidth() > source.getHeight()) {
                width = previewMax;
                height = width * source.getHeight() / source.getWidth();
            } else {
                height = previewMax;
                width = height * source.getWidth() / source.getHeight();
            }
            if (maxDimension) {
                previewWidth = previewMax;
                previewHeight = previewMax;
            } else {
                previewWidth = width;
                previewHeight = height;
            }
            BufferedImage destination = new BufferedImage(previewWidth, previewHeight, source.getType());
            Graphics2D g = destination.createGraphics();
            g.drawImage(source, (previewWidth - width) / 2, (previewHeight - height) / 2, width, height, null);
            g.dispose();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)destination, contentType.split("/")[1], output);
            ResourceStreamBean bean = new ResourceStreamBean();
            bean.setName(resource.getName());
            bean.setContentType(contentType);
            bean.setResourceContent(new ByteArrayInputStream(output.toByteArray()));
            return bean;
        }
        catch (IOException | SQLException e) {
            throw new PollenTechnicalException("error get preview resource", e);
        }
    }

    public PollenEntityRef<PollenResource> createResource(ResourceFileBean resource) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(resource);
        this.checkIsNotPersisted(resource);
        if (ResourceType.GTU.equals((Object)resource.getResourceType())) {
            this.checkIsAdmin();
        }
        PollenErrors pollenErrors = this.checkRessource(resource);
        pollenErrors.failIfNotEmpty();
        PollenResource savedResource = this.saveResource(resource);
        this.commit();
        return PollenEntityRef.of(savedResource);
    }

    public PollenResource createAvatarResource(AbstractResourceBean resource) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(resource);
        this.checkIsNotPersisted(resource);
        PollenErrors pollenErrors = this.checkRessource(resource);
        pollenErrors.failIfNotEmpty();
        PollenResource avatarResource = this.saveResource(resource);
        return (PollenResource)this.getPollenResourceDao().create((PollenEntity)avatarResource);
    }

    public void deleteResource(PollenEntityId<PollenResource> resourceId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(resourceId);
        this.checkIsAdmin();
        PollenResource resource = this.getResource0(resourceId);
        if (ResourceType.GTU.equals((Object)resource.getResourceType())) {
            this.checkIsAdmin();
        }
        this.getPollenResourceDao().delete(resource);
        this.commit();
    }

    public ResourceStreamBean getAvatar(String userId) {
        this.checkIsConnectedRequired();
        PollenResource resource = this.getPollenResourceDao().findAvatarForUser(userId);
        return this.toResourceStreamBean(resource);
    }

    protected PollenResource getResource0(String resourceId) {
        return (PollenResource)this.getPollenResourceDao().forTopiaIdEquals(resourceId).findUnique();
    }

    protected PollenResource getResource0(PollenEntityId<PollenResource> resourceId) {
        return (PollenResource)this.getPollenResourceDao().forTopiaIdEquals(resourceId.getEntityId()).findUnique();
    }

    protected PollenResource saveResource(AbstractResourceBean resource) {
        boolean resourceExist = resource.isPersisted();
        PollenResource toSave = resourceExist ? this.getResource0(resource.getEntityId()) : (PollenResource)this.getPollenResourceDao().create();
        toSave.setName(resource.getName());
        toSave.setContentType(resource.getContentType());
        toSave.setSize(resource.getSize());
        toSave.setResourceType(resource.getResourceType());
        toSave.setResourceContent(resource.getResourceBlob());
        return toSave;
    }

    protected String getTopiaIdByReduceId(String shortId) {
        PollenEntityId<PollenResource> resourceId = PollenEntityId.ofDecoded(PollenResource.class, shortId);
        return resourceId.getEntityId();
    }

    protected String getReduceIdByTopiaId(String topiaId) {
        PollenEntityId<PollenResource> resourceId = PollenEntityId.of(PollenResource.class, topiaId);
        return resourceId.getReducedId();
    }

    protected PollenErrors checkRessource(AbstractResourceBean resource) {
        PollenErrors pollenErrors = new PollenErrors();
        if (resource.getSize() > this.getPollenServiceConfig().getResourceMaxSize()) {
            UnitHuman sizeUnitHuman = UnitHuman.getUnitHuman(resource.getSize());
            UnitHuman maxUnitHuman = UnitHuman.getUnitHuman(this.getPollenServiceConfig().getResourceMaxSize());
            pollenErrors.addError("size", PollenServiceErrorIssue.RESOURCE_MAX_SIZE, resource.getSize(), this.getLocale(), resource.getName(), sizeUnitHuman.getUnitValue(resource.getSize()), sizeUnitHuman.getUnit("o"), maxUnitHuman.getUnitValue(this.getPollenServiceConfig().getResourceMaxSize()), maxUnitHuman.getUnit("o"));
        }
        this.checkNotNull(pollenErrors, "resourceType", resource.getResourceType(), PollenServiceErrorIssue.RESOURCE_TYPE_REQUIRED, new Object[0]);
        return pollenErrors;
    }
}

