/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.entities.migration;

import com.opensymphony.xwork2.ActionContext;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenApplicationContext;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountImpl;
import org.chorem.pollen.business.persistence.PollImpl;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VoteToChoiceImpl;
import org.chorem.pollen.services.DefaultPollenServiceContext;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.chorem.pollen.services.impl.PollFeedService;
import org.chorem.pollen.services.impl.PollService;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaSQLQuery;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClassNG;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public class PollenMigrationCallbackV1_4
extends TopiaMigrationCallbackByClassNG.MigrationCallBackForVersion {
    private static final Log log = LogFactory.getLog(PollenMigrationCallbackV1_4.class);

    public Version getVersion() {
        return VersionUtil.valueOf((String)"1.4");
    }

    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {
        this.removeAllCondorcetNullVotes(tx, queries);
        this.addResultUptodateToPoll(queries);
        this.generateMissingPollFeedFiles(tx);
        this.generateMissingImageThumbs(tx);
        this.addUniqueOnPollIds(queries);
        this.addTimestampOnTopiaCreateDate(queries);
    }

    private void addTimestampOnTopiaCreateDate(List<String> queries) {
        queries.add("alter TABLE vote ALTER COLUMN topiacreatedate type timestamp;");
        queries.add("alter TABLE comment ALTER COLUMN topiacreatedate type timestamp;");
    }

    private void addUniqueOnPollIds(List<String> queries) {
        queries.add("CREATE UNIQUE INDEX idx_P\u00f6ll_pollId ON poll(pollId);");
    }

    private void generateMissingImageThumbs(TopiaContextImplementor tx) throws TopiaException {
        TopiaSQLQuery<Pair<String, String>> getAllImageChoicesQuery = new TopiaSQLQuery<Pair<String, String>>(){

            protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("SELECT p.pollId, c.name FROM choice c, poll p WHERE c.poll = p.topiaid AND p.choicetype=2;");
                return ps;
            }

            protected Pair<String, String> prepareResult(ResultSet set) throws SQLException {
                String pollId = set.getString(1);
                String choiceName = set.getString(2);
                return Pair.of((Object)pollId, (Object)choiceName);
            }
        };
        PollenServiceFactory serviceFactory = new PollenServiceFactory();
        PollenApplicationContext applicationContext = PollenApplicationContext.get(ActionContext.getContext());
        PollenConfiguration configuration = applicationContext.getConfiguration();
        PollenServiceContext sContext = DefaultPollenServiceContext.newContext(Locale.getDefault(), (TopiaContext)tx, configuration, serviceFactory, applicationContext.getVoteCountingFactory());
        List choiceIds = getAllImageChoicesQuery.findMultipleResult(tx);
        PollService service = sContext.newService(PollService.class);
        for (Pair choiceId : choiceIds) {
            String choiceName;
            String pollId = (String)choiceId.getLeft();
            File imageFile = service.getPollChoiceImageFile(pollId, choiceName = (String)choiceId.getRight());
            if (!imageFile.exists()) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Could not find image choice " + imageFile));
                continue;
            }
            try {
                service.generateThumbIfNeeded(imageFile);
            }
            catch (IOException e) {
                throw new TopiaException("Could not create thumb for " + imageFile, (Throwable)e);
            }
        }
    }

    private void generateMissingPollFeedFiles(TopiaContextImplementor tx) throws TopiaException {
        TopiaSQLQuery<Poll> getAllPollIdsQuery = new TopiaSQLQuery<Poll>(){

            protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("SELECT p.pollId, p.title, p.description, c.votingId  FROM poll p, PollAccount c WHERE p.creator = c.topiaId;");
                return ps;
            }

            protected Poll prepareResult(ResultSet set) throws SQLException {
                String pollId = set.getString(1);
                String pollTitle = set.getString(2);
                String pollDescription = set.getString(3);
                String votingId = set.getString(4);
                PollImpl poll = new PollImpl();
                poll.setPollId(pollId);
                poll.setTitle(pollTitle);
                poll.setDescription(pollDescription);
                PollAccountImpl pollAccount = new PollAccountImpl();
                pollAccount.setVotingId(votingId);
                poll.setCreator((PollAccount)pollAccount);
                return poll;
            }
        };
        PollenServiceFactory serviceFactory = new PollenServiceFactory();
        PollenApplicationContext applicationContext = PollenApplicationContext.get(ActionContext.getContext());
        PollenConfiguration configuration = applicationContext.getConfiguration();
        PollenServiceContext sContext = DefaultPollenServiceContext.newContext(Locale.getDefault(), (TopiaContext)tx, configuration, serviceFactory, applicationContext.getVoteCountingFactory());
        PollFeedService feedService = sContext.newService(PollFeedService.class);
        List polls = getAllPollIdsQuery.findMultipleResult(tx);
        for (Poll poll : polls) {
            boolean feedExists = feedService.isFeedExists(poll);
            if (feedExists) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Create missing file " + feedService.getFeedLocation(poll)));
            }
            feedService.onPollCreated(poll);
        }
    }

    private void addResultUptodateToPoll(List<String> queries) {
        queries.add("ALTER TABLE poll ADD COLUMN resultuptodate boolean default false;");
    }

    private void removeAllCondorcetNullVotes(TopiaContextImplementor tx, List<String> queries) throws TopiaException {
        TopiaSQLQuery<String> getAllVotesQuery = new TopiaSQLQuery<String>(){

            protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("select topiaid from vote where poll in (select topiaid from poll where votecountingtype=2);");
                return ps;
            }

            protected String prepareResult(ResultSet set) throws SQLException {
                return set.getString(1);
            }
        };
        List voteIds = getAllVotesQuery.findMultipleResult(tx);
        for (String voteId : voteIds) {
            List voteToChoices = new GetVoteToChoiceSQLQuery(voteId).findMultipleResult(tx);
            for (VoteToChoice voteToChoice : voteToChoices) {
                if (voteToChoice == null || voteToChoice.getVoteValue() > 0) continue;
                queries.add("DELETE FROM votetochoice where topiaid ='" + voteToChoice.getTopiaId() + "';");
            }
        }
    }

    private static class GetVoteToChoiceSQLQuery
    extends TopiaSQLQuery<VoteToChoice> {
        private final String voteId;

        public GetVoteToChoiceSQLQuery(String voteId) {
            this.voteId = voteId;
        }

        protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
            PreparedStatement ps = connection.prepareStatement("SELECT topiaid, votevalue FROM votetochoice WHERE vote = ?;");
            ps.setString(1, this.voteId);
            return ps;
        }

        protected VoteToChoice prepareResult(ResultSet set) throws SQLException {
            VoteToChoiceImpl result = new VoteToChoiceImpl();
            result.setTopiaId(set.getString(1));
            result.setVoteValue(Integer.valueOf(set.getInt(2)));
            return result;
        }
    }
}

