/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.entities.migration;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.opensymphony.xwork2.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenApplicationContext;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.chorem.pollen.services.DefaultPollenServiceContext;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.chorem.pollen.services.impl.VoteService;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaSQLQuery;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClassNG;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

public class PollenMigrationCallbackV1_5
extends TopiaMigrationCallbackByClassNG.MigrationCallBackForVersion {
    private static final Log log = LogFactory.getLog(PollenMigrationCallbackV1_5.class);
    final Function<Vote, UserAccount> voteToUserAccount = new Function<Vote, UserAccount>(){

        public UserAccount apply(Vote input) {
            PollAccount pollAccount = input.getPollAccount();
            return pollAccount == null ? null : pollAccount.getUserAccount();
        }
    };

    public Version getVersion() {
        return VersionUtil.valueOf((String)"1.5");
    }

    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {
        PollenApplicationContext applicationContext = PollenApplicationContext.get(ActionContext.getContext());
        PollenServiceContext sContext = DefaultPollenServiceContext.newContext(Locale.getDefault(), (TopiaContext)tx, applicationContext.getConfiguration(), new PollenServiceFactory(), applicationContext.getVoteCountingFactory());
        this.removeDuplicateVoteWithSameUserAccount(tx, sContext, queries);
        this.generateMissingAccountId(tx, sContext, queries);
        this.removeResults(tx, queries);
        this.removeHiddenChoices(tx, queries);
    }

    private void removeResults(TopiaContextImplementor tx, List<String> queries) {
        queries.add("DROP TABLE result;");
        queries.add("ALTER TABLE poll DROP COLUMN resultUptodate");
    }

    private void removeHiddenChoices(TopiaContextImplementor tx, List<String> queries) {
        queries.add("DELETE FROM votetochoice WHERE choice in (SELECT topiaid FROM choice WHERE name LIKE 'HIDDEN_%');");
        queries.add("DELETE FROM choice WHERE name LIKE 'HIDDEN_%';");
    }

    private void removeDuplicateVoteWithSameUserAccount(TopiaContextImplementor tx, PollenServiceContext sContext, List<String> queries) throws TopiaException {
        Set pollToFix;
        TopiaSQLQuery<String> getAllPollIdsQuery = new TopiaSQLQuery<String>(){

            protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("SELECT p.pollid FROM poll p WHERE (SELECT COUNT(pa) > COUNT(DISTINCT(pa.useraccount)) FROM vote v,pollaccount pa WHERE v.poll = p.topiaid AND v.pollaccount = pa.topiaid AND pa.useraccount IS NOT NULL);");
                return ps;
            }

            protected String prepareResult(ResultSet set) throws SQLException {
                String pollId = set.getString(1);
                return pollId;
            }
        };
        List pollIds = getAllPollIdsQuery.findMultipleResult(tx);
        PollDAO pollDAO = PollenDAOHelper.getPollDAO((TopiaContext)tx);
        VoteService voteService = sContext.newService(VoteService.class);
        ArrayListMultimap accountToAnonymous = ArrayListMultimap.create();
        ArrayListMultimap voteToFixByPoll = ArrayListMultimap.create();
        long nbPolls = pollIds.size();
        int currentPollIndex = 0;
        for (String pollId : pollIds) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Treat bad poll [" + currentPollIndex++ + "/" + nbPolls + "]" + pollId));
            }
            Poll poll = pollDAO.findByPollId(pollId);
            boolean pollAnonymous = poll.isAnonymous();
            List<Vote> votes = voteService.getAllVotes(poll);
            ArrayListMultimap voteByUserAccount = ArrayListMultimap.create();
            for (Vote vote : votes) {
                UserAccount useraccount = (UserAccount)this.voteToUserAccount.apply((Object)vote);
                if (useraccount == null) continue;
                voteByUserAccount.put((Object)useraccount, (Object)vote);
            }
            for (UserAccount userAccount : voteByUserAccount.keySet()) {
                Collection votesForUser;
                if (userAccount == null || (votesForUser = voteByUserAccount.get((Object)userAccount)).size() <= 1) continue;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Poll" + (pollAnonymous ? "(anonymous)" : "") + " [" + poll.getPollId() + "] with multi vote for the same userAccount : " + userAccount.getEmail()));
                }
                if (pollAnonymous) {
                    for (Vote vote : votesForUser) {
                        accountToAnonymous.put((Object)poll, (Object)vote.getPollAccount());
                    }
                    continue;
                }
                voteToFixByPoll.putAll((Object)poll, (Iterable)votesForUser);
            }
        }
        Set anonymousPollToFix = accountToAnonymous.keySet();
        if (CollectionUtils.isNotEmpty((Collection)anonymousPollToFix)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("There is " + anonymousPollToFix.size() + " anonymous " + "poll to fix, will remove the userAccount from " + "anonymous votes"));
            }
            String request = "UPDATE pollaccount set useraccount = NULL WHERE topiaid='%s';";
            for (PollAccount account : accountToAnonymous.values()) {
                queries.add(String.format(request, account.getTopiaId()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(pollToFix = voteToFixByPoll.keySet()))) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("There is " + pollToFix.size() + " other polls " + "to fix, will remove the userAccount from any votes"));
            }
            String request = "UPDATE pollaccount set useraccount = NULL WHERE topiaid='%s';";
            for (Vote account : voteToFixByPoll.values()) {
                queries.add(String.format(request, account.getPollAccount().getTopiaId()));
            }
        }
    }

    private void generateMissingAccountId(TopiaContextImplementor tx, PollenServiceContext sContext, List<String> queries) throws TopiaException {
        TopiaSQLQuery<String> sqlQuery = new TopiaSQLQuery<String>(){

            protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("SELECT p.topiaId FROM pollAccount p, vote v WHERE p.accountId = '' AND v.pollaccount = p.topiaid");
                return ps;
            }

            protected String prepareResult(ResultSet set) throws SQLException {
                String pollAccountId = set.getString(1);
                return pollAccountId;
            }
        };
        List accountIds = sqlQuery.findMultipleResult(tx);
        String request = "UPDATE pollaccount set accountId = '%s' WHERE topiaid='%s';";
        for (String id : accountIds) {
            queries.add(String.format(request, sContext.generateId(), id));
        }
    }
}

