/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.topia;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.chorem.pollen.persistence.topia.TopiaException;
import org.hibernate.HibernateException;
import org.hibernate.tool.schema.internal.AbstractSchemaValidator;

public class SchemaValidationTopiaException
extends TopiaException {
    protected static final Predicate<StackTraceElement> IS_STACK_TRACE_ELEMENT_ABOUT_SCHEMA_VALIDATION = input -> input.getClassName().equals(AbstractSchemaValidator.class.getName()) && input.getMethodName().equals("doValidation");

    public SchemaValidationTopiaException(String message, HibernateException e) {
        super(message, e);
    }

    public static void throwIfHibernateExceptionIsAboutSchemaValidation(HibernateException hibernateException) {
        boolean stackTraceIsAboutSchemaValidation = Iterables.any(Arrays.asList(hibernateException.getStackTrace()), IS_STACK_TRACE_ELEMENT_ABOUT_SCHEMA_VALIDATION);
        if (stackTraceIsAboutSchemaValidation) {
            throw new SchemaValidationTopiaException(hibernateException.getMessage(), hibernateException);
        }
    }
}

