/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.topia;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.text.WordUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.nuiton.util.pagination.PaginationOrder;

public class HqlAndParametersBuilder<E extends PollenEntity> {
    private static final String DEFAULT_ALIAS = "topiaEntity_";
    protected Joiner hqlClausesJoiner = Joiner.on((char)' ').skipNulls();
    protected Class<E> entityClass;
    protected String selectClause;
    protected Set<String> whereClauses = Sets.newLinkedHashSet();
    private final String alias;
    protected LinkedHashSet<String> orderByArguments;
    protected Map<String, Object> parameters = Maps.newLinkedHashMap();
    protected Set<String> fetchProperties = Sets.newLinkedHashSet();

    public HqlAndParametersBuilder(Class<E> entityClass) {
        this(entityClass, DEFAULT_ALIAS);
    }

    public HqlAndParametersBuilder(Class<E> entityClass, String alias) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)alias));
        this.entityClass = entityClass;
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getHqlSelectClause(boolean includeFetch) {
        String result = this.selectClause;
        if (includeFetch && !CollectionUtils.isEmpty(this.fetchProperties)) {
            Preconditions.checkState((boolean)Strings.isNullOrEmpty((String)result), (Object)"You cannot fetch if you specify a select clause");
            result = String.format(" SELECT DISTINCT %s ", this.alias);
        }
        return result;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    public void addNull(String property) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)property));
        this.whereClauses.add(this.alias + "." + property + " is null");
    }

    public void addNotNull(String property) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)property));
        this.whereClauses.add(this.alias + "." + property + " is not null");
    }

    public void addEquals(String property, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        if (value == null) {
            this.addNull(property);
        } else {
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
            this.whereClauses.add(this.alias + "." + property + " = :" + hqlParameterName);
        }
    }

    public void addNotEquals(String property, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        if (value == null) {
            this.addNotNull(property);
        } else {
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
            this.whereClauses.add(this.alias + "." + property + " != :" + hqlParameterName);
        }
    }

    public void addIn(String property, Collection<?> values) {
        this.addInOrNotIn(property, values, true);
    }

    public void addNotIn(String property, Collection<?> values) {
        this.addInOrNotIn(property, values, false);
    }

    protected void addInOrNotIn(String property, Collection<?> values, boolean in) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        Preconditions.checkNotNull(values);
        String aliasedProperty = this.alias + "." + property;
        int valuesSize = values.size();
        if (valuesSize == 0) {
            if (in) {
                this.whereClauses.add(" 0 = 1 ");
            } else {
                this.whereClauses.add(" 1 = 1 ");
            }
        } else if (valuesSize == 1) {
            Object onlyElement = Iterables.getOnlyElement(values);
            if (in) {
                this.addEquals(property, onlyElement);
            } else {
                this.addNotEquals(property, onlyElement);
            }
        } else {
            Object whereClause;
            boolean propertyMayBeNull = values.contains(null);
            LinkedHashSet hqlParameterValue = values;
            if (propertyMayBeNull) {
                hqlParameterValue = Sets.newLinkedHashSet(values);
                hqlParameterValue.remove(null);
            }
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, hqlParameterValue);
            if (in) {
                whereClause = String.format(" %s in ( :%s ) ", aliasedProperty, hqlParameterName);
                if (propertyMayBeNull) {
                    whereClause = (String)whereClause + " or " + aliasedProperty + " is null";
                }
            } else {
                whereClause = String.format(" %s not in ( :%s ) ", aliasedProperty, hqlParameterName);
                if (propertyMayBeNull) {
                    whereClause = (String)whereClause + " and " + aliasedProperty + " is not null";
                }
            }
            this.whereClauses.add((String)whereClause);
        }
    }

    public void addTopiaIdEquals(String property, String topiaId) {
        Preconditions.checkNotNull((Object)topiaId);
        this.addEquals(property + ".topiaId", topiaId);
    }

    public void addTopiaIdIn(String property, Collection<String> topiaIds) {
        this.addIn(property + ".topiaId", topiaIds);
    }

    public void addTopiaIdNotEquals(String property, String topiaId) {
        Preconditions.checkNotNull((Object)topiaId);
        this.addNotEquals(property + ".topiaId", topiaId);
    }

    public void addTopiaIdNotIn(String property, Collection<String> topiaIds) {
        this.addNotIn(property + ".topiaId", topiaIds);
    }

    public void addContains(String property, Object value) {
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
        this.whereClauses.add(":" + hqlParameterName + " in elements(" + this.alias + "." + property + ")");
    }

    public void addLowerThan(String property, Date date) {
        this.doAddLowerThan(property, date);
    }

    public void addLowerOrEquals(String property, Date date) {
        this.doAddLowerOrEquals(property, date);
    }

    protected void doAddLowerThan(String property, Object value) {
        Preconditions.checkNotNull((Object)value);
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
        this.whereClauses.add(this.alias + "." + property + " < :" + hqlParameterName);
    }

    protected void doAddLowerOrEquals(String property, Object value) {
        Preconditions.checkNotNull((Object)value);
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
        this.whereClauses.add(this.alias + "." + property + " <= :" + hqlParameterName);
    }

    public void addWhereClause(String whereClause) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)whereClause));
        this.whereClauses.add(whereClause);
    }

    public void setParameters(Map<String, Object> parameters) {
        Preconditions.checkNotNull(parameters);
        this.parameters = parameters;
    }

    public void setOrderByArguments(String ... orderByArguments) {
        Preconditions.checkNotNull((Object)orderByArguments);
        LinkedHashSet orderByArgumentsAsSet = Sets.newLinkedHashSet();
        ArrayList list = Lists.newArrayList((Object[])orderByArguments);
        orderByArgumentsAsSet.addAll(list);
        if (orderByArgumentsAsSet.size() < list.size()) {
            throw new IllegalStateException("Duplicate ORDER BY arguments found: " + String.valueOf(list));
        }
        this.orderByArguments = orderByArgumentsAsSet;
    }

    public void setOrderByArguments(Collection<PaginationOrder> paginationOrders) {
        Preconditions.checkNotNull(paginationOrders);
        LinkedHashSet orderByArgumentsAsSet = Sets.newLinkedHashSet();
        for (PaginationOrder paginationOrder : paginationOrders) {
            Object[] objectArray = new Object[2];
            objectArray[0] = paginationOrder.getClause();
            Object object = objectArray[1] = paginationOrder.isDesc() ? "desc" : "asc";
            String orderClause = String.format("%s %s", objectArray);
            boolean added = orderByArgumentsAsSet.add(orderClause);
            if (added) continue;
            throw new IllegalStateException("Duplicate ORDER BY arguments found: " + orderClause);
        }
        this.orderByArguments = orderByArgumentsAsSet;
    }

    public boolean hasFetchProperties() {
        return !this.fetchProperties.isEmpty();
    }

    protected String getHqlFromClause(boolean includeFetch) {
        StringBuilder hqlFromClauseBuilder = new StringBuilder(String.format("FROM %s %s ", this.entityClass.getCanonicalName(), this.alias));
        if (includeFetch) {
            int fetchedPropertiesAliasIndex = 0;
            HashMap aliases = Maps.newHashMap();
            for (String propertyName : this.fetchProperties) {
                StringBuilder path = new StringBuilder();
                for (String part : Splitter.on((char)'.').split((CharSequence)propertyName)) {
                    String previousPath = path.toString();
                    String previousAlias = (String)MoreObjects.firstNonNull((Object)((String)aliases.get(previousPath)), (Object)this.alias);
                    if (!path.isEmpty()) {
                        path.append('.');
                    }
                    path.append(part);
                    String currentPath = path.toString();
                    String currentAlias = (String)aliases.get(currentPath);
                    if (!Strings.isNullOrEmpty((String)currentAlias)) continue;
                    currentAlias = String.format("fetchedProp%d_", fetchedPropertiesAliasIndex++);
                    aliases.put(currentPath, currentAlias);
                    String fetch = String.format(" LEFT JOIN FETCH %s.%s %s ", previousAlias, part, currentAlias);
                    hqlFromClauseBuilder.append(fetch);
                }
            }
        }
        return hqlFromClauseBuilder.toString();
    }

    public String getHqlWhereClause() {
        String hqlWhereClause;
        if (this.whereClauses.isEmpty()) {
            hqlWhereClause = null;
        } else if (this.whereClauses.size() == 1) {
            String whereClause = (String)Iterables.getOnlyElement(this.whereClauses);
            hqlWhereClause = "where " + whereClause;
        } else {
            hqlWhereClause = "where (" + StringUtils.join(this.whereClauses, (String)") and (") + ")";
        }
        return hqlWhereClause;
    }

    public String getHqlOrderByClause() {
        String hqlOrderByClause = null;
        if (CollectionUtils.isNotEmpty(this.orderByArguments)) {
            hqlOrderByClause = "order by " + this.alias + "." + StringUtils.join(this.orderByArguments, (String)(", " + this.alias + "."));
        }
        return hqlOrderByClause;
    }

    public String getHql() {
        return this.hqlClausesJoiner.join((Object)this.getHqlSelectClause(true), (Object)this.getHqlFromClause(true), new Object[]{this.getHqlWhereClause(), this.getHqlOrderByClause()});
    }

    public String getHqlForFetchStep1() {
        String selectClause = "select " + this.alias + ".topiaId " + Strings.nullToEmpty((String)this.getHqlSelectClause(false));
        return this.hqlClausesJoiner.join((Object)selectClause, (Object)this.getHqlFromClause(false), new Object[]{this.getHqlWhereClause(), this.getHqlOrderByClause()});
    }

    public String getHqlForFetchStep2() {
        String whereClause = "where " + this.alias + ".topiaId in ( :topiaIdsForFetch_ ) ";
        return this.hqlClausesJoiner.join((Object)this.getHqlSelectClause(true), (Object)this.getHqlFromClause(true), new Object[]{whereClause});
    }

    protected String getParameterName(String propertyName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)propertyName));
        String capitalize = WordUtils.capitalize((String)propertyName, (char[])new char[]{'.'});
        String withoutDots = capitalize.replaceAll("\\.", "");
        return StringUtils.uncapitalize((String)withoutDots);
    }

    protected String putHqlParameterWithAvailableName(String propertyName, Object value) {
        String parameterNamePrefix = this.getParameterName(propertyName);
        int suffix = 0;
        String parameterName = parameterNamePrefix + suffix;
        while (this.parameters.containsKey(parameterName)) {
            parameterName = parameterNamePrefix + ++suffix;
        }
        this.parameters.put(parameterName, value);
        return parameterName;
    }

    public Map<String, Object> getHqlParameters() {
        return this.parameters;
    }

    public boolean isOrderByClausePresent() {
        return CollectionUtils.isNotEmpty(this.orderByArguments);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("hql", (Object)this.getHql()).append("hqlParameters", this.getHqlParameters()).toString();
    }
}

