/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.List;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;

public class QuestionDao
extends AbstractPollenDao<Question> {
    @Override
    public Class<Question> getEntityClass() {
        return Question.class;
    }

    @Override
    public void delete(Question entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        List list = this.daoSupplier.getChoiceDao().forQuestionEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Choice)item).getQuestion())) continue;
            ((Choice)item).setQuestion(null);
        }
        list = this.daoSupplier.getVoteDao().forQuestionEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Vote)item).getQuestion())) continue;
            ((Vote)item).setQuestion(null);
        }
        list = this.daoSupplier.getCommentDao().forQuestionEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Comment)item).getQuestion())) continue;
            ((Comment)item).setQuestion(null);
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<Question> forPollEquals(Poll v) {
        return this.forEquals("poll", v);
    }

    public List<Question> findAllByPollOrdered(Poll poll) {
        return this.forPollEquals(poll).setOrderByArguments("questionOrder").findAll();
    }
}

