package org.chorem.pollen.business.persistence;

import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public interface PollAccount extends TopiaEntity {

    String PROPERTY_ACCOUNT_ID = "accountId";

    String PROPERTY_VOTING_ID = "votingId";

    String PROPERTY_EMAIL = "email";

    String PROPERTY_VOTING_LIST_PERSON_TO_LIST = "votingListPersonToList";

    String PROPERTY_VOTE = "vote";

    String PROPERTY_PERSON_LIST = "personList";

    String PROPERTY_USER_ACCOUNT = "userAccount";

    void setAccountId(String accountId);

    String getAccountId();

    void setVotingId(String votingId);

    String getVotingId();

    void setEmail(String email);

    String getEmail();

    void addVotingListPersonToList(PersonToList votingListPersonToList);

    void addAllVotingListPersonToList(List<PersonToList> votingListPersonToList);

    void setVotingListPersonToList(List<PersonToList> votingListPersonToList);

    void removeVotingListPersonToList(PersonToList votingListPersonToList);

    void clearVotingListPersonToList();

    List<PersonToList> getVotingListPersonToList();

    PersonToList getVotingListPersonToListByTopiaId(String topiaId);

    PersonToList getVotingListPersonToList(VotingList votingList);

    int sizeVotingListPersonToList();

    boolean isVotingListPersonToListEmpty();

    void addVote(Vote vote);

    void addAllVote(List<Vote> vote);

    void setVote(List<Vote> vote);

    void removeVote(Vote vote);

    void clearVote();

    List<Vote> getVote();

    Vote getVoteByTopiaId(String topiaId);

    int sizeVote();

    boolean isVoteEmpty();

    void setPersonList(PersonList personList);

    PersonList getPersonList();

    void setUserAccount(UserAccount userAccount);

    UserAccount getUserAccount();

} //PollAccount
