/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataUserConverter;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * Implémentation du service d'authentification.
 *
 * @author kmorin
 * @author rannou
 * @version $Id: ServiceAuthImpl.java 2737 2009-08-20 13:00:52Z nrannou $
 */
public class ServiceAuthImpl implements ServiceAuth {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private UserAccountDAO userDAO = null;
    private DataUserConverter converter = new DataUserConverter();

    /** log. */
    private static final Log log = LogFactory.getLog(ServiceAuthImpl.class);

    public ServiceAuthImpl() {
    }

    @Override
    public boolean isLoginRight(String login, String password) {
        TopiaContext transaction = null;
        boolean result = false;
        try {
            transaction = rootContext.beginTransaction();

            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);

            UserAccount userEntity = userDAO.findByLogin(login);
            if (userEntity != null && password.equals(userEntity.getPassword())) {
                result = true;
            }

            transaction.commitTransaction();
            transaction.closeContext();

            if (log.isDebugEnabled()) {
                log.debug("Entity found: "
                        + ((userEntity == null) ? "null" : userEntity
                                .getLogin()));
            }

            return result;
        } catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public UserDTO getUser(String login, String password) {
        TopiaContext transaction = null;
        UserDTO result = null;
        try {
            transaction = rootContext.beginTransaction();

            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);

            UserAccount userEntity = userDAO.findByLogin(login);
            if (userEntity != null && password.equals(userEntity.getPassword())) {
                result = converter.createUserDTO(userEntity);
            }

            transaction.commitTransaction();
            transaction.closeContext();

            if (log.isDebugEnabled()) {
                log.debug("Entity found: "
                        + ((result == null) ? "null" : result.getLogin()));
            }

            return result;
        } catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }
}