/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.components.Checkbox;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(library={"../Chenillekit.js", "AjaxCheckbox.js"})
public class AjaxCheckbox
extends Checkbox {
    public static final String EVENT_NAME = "checkboxclicked";
    private static final String INTERNAL_EVENT_NAME = "internal_clicked";
    @Parameter(required=false, defaultPrefix="literal")
    private String onCompleteCallback;
    @Parameter
    private Object[] context;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport javascriptSupport;

    void afterRender(MarkupWriter writer) {
        String event = INTERNAL_EVENT_NAME;
        String ajaxString = "new Ck.AjaxCheckbox('%s', '%s'";
        if (this.onCompleteCallback != null) {
            ajaxString = ajaxString + ",'" + this.onCompleteCallback + "'";
            event = EVENT_NAME;
        }
        ajaxString = ajaxString + ");";
        Link link = this.resources.createEventLink(event, this.context);
        this.javascriptSupport.addScript(ajaxString, new Object[]{this.getClientId(), link.toAbsoluteURI()});
    }

    @OnEvent(value="internal_clicked")
    Object checkboxClicked(EventContext context) {
        final Holder valueHolder = Holder.create();
        ComponentEventCallback<Object> callback = new ComponentEventCallback<Object>(){

            public boolean handleResult(Object result) {
                valueHolder.put(result);
                return true;
            }
        };
        this.resources.triggerContextEvent(EVENT_NAME, context, (ComponentEventCallback)callback);
        return valueHolder.get();
    }
}

