/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.services.impl;

import java.io.IOException;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.chenillekit.core.resources.URIResource;
import org.chenillekit.tapestry.core.ChenilleKitCoreConstants;
import org.chenillekit.tapestry.core.services.URIAssetAliasManager;

public class URIDispatcher
implements Dispatcher {
    private final ResourceStreamer streamer;
    private final URIAssetAliasManager aliasManager;

    public URIDispatcher(ResourceStreamer streamer, URIAssetAliasManager aliasManager) {
        this.streamer = streamer;
        this.aliasManager = aliasManager;
    }

    public boolean dispatch(Request request, Response response) throws IOException {
        String path = request.getPath();
        if (!path.startsWith(ChenilleKitCoreConstants.URI_PATH_PREFIX)) {
            return false;
        }
        String resourcePath = this.aliasManager.toResourcePath(path);
        URIResource resource = new URIResource(resourcePath);
        if (!resource.exists()) {
            response.sendError(404, String.format("asset '%s' doesn exists!", resource));
            return true;
        }
        this.streamer.streamResource((Resource)resource);
        return true;
    }
}

