/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(library={"../Chenillekit.js", "Tooltip.js"}, stylesheet={"Tooltip.css"})
public class Tooltip {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(value="", required=false, defaultPrefix="literal")
    private String title;
    @Parameter(value="", required=false, defaultPrefix="literal")
    private String value;
    @Parameter(required=false, defaultPrefix="literal")
    private String effect;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private Environment environment;
    private String assignedClientId;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    @BeginRender
    void beginRender(MarkupWriter writer) {
        writer.element("span", new Object[]{"id", this.assignedClientId});
    }

    @AfterRender
    void afterRender(MarkupWriter writer) {
        writer.end();
        String jsCommand = "new Ck.Tip('%s', '%s'";
        jsCommand = jsCommand + ", {className: 'ck_tooltip'";
        if (this.title != null) {
            jsCommand = jsCommand + ", title: '" + this.replaceJSChar(this.title) + "'";
        }
        if (this.effect != null) {
            jsCommand = jsCommand + ", effect: '" + this.effect + "'";
        }
        jsCommand = jsCommand + "});";
        this.javascriptSupport.addScript(jsCommand, new Object[]{this.assignedClientId, this.replaceJSChar(this.value)});
    }

    private String replaceJSChar(String value) {
        if (value == null) {
            return "";
        }
        return value.replaceAll("'", "\"").replaceAll("%", "%%");
    }
}

