/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import javax.swing.text.MaskFormatter;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

@SupportsInformalParameters
public class MaskFormat {
    @Inject
    private Logger logger;
    @Parameter(required=true)
    private String value;
    @Parameter(required=true, defaultPrefix="literal")
    private String mask;
    @Parameter(required=false, defaultPrefix="literal")
    private String placeholder;
    @Parameter(required=false, defaultPrefix="literal")
    private String validCharacters;
    @Inject
    private ComponentResources resources;

    private String getFormatedValue() {
        try {
            MaskFormatter mf = new MaskFormatter(this.mask);
            mf.setValueContainsLiteralCharacters(false);
            if (this.placeholder != null) {
                mf.setPlaceholderCharacter(this.placeholder.toCharArray()[0]);
            }
            if (this.validCharacters != null) {
                mf.setValidCharacters(this.validCharacters);
            }
            return mf.valueToString(this.value);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            return this.value;
        }
    }

    void beginRender(MarkupWriter writer) {
        String formattedValue = this.getFormatedValue();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("parameter value: %s / transformed value: %s", (Object)this.value, (Object)formattedValue);
        }
        writer.element("span", new Object[0]);
        this.resources.renderInformalParameters(writer);
        writer.write(formattedValue);
        writer.end();
    }
}

