/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.bindings;

import java.util.Map;
import ognl.Ognl;
import org.apache.tapestry5.internal.bindings.AbstractBinding;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.TapestryException;

public class OgnlBinding
extends AbstractBinding {
    private static final Map<String, Object> _cache = CollectionFactory.newMap();
    private String _expression;
    private Object _root;

    public OgnlBinding(Location location, Object root, String expression) {
        super(location);
        this._expression = expression;
        this._root = root;
    }

    public synchronized Object getParsedExpression(String expression) {
        Object result = _cache.get(expression);
        if (result == null) {
            try {
                result = Ognl.parseExpression((String)expression);
            }
            catch (Exception ex) {
                throw new TapestryException(ex.getLocalizedMessage(), this.getLocation(), (Throwable)ex);
            }
            _cache.put(expression, result);
        }
        return result;
    }

    public Object get() {
        Object ognlExpression = this.getParsedExpression(this._expression);
        try {
            Map context = Ognl.createDefaultContext((Object)this._root);
            return Ognl.getValue((Object)ognlExpression, (Map)context, (Object)this._root);
        }
        catch (Exception ex) {
            throw new TapestryException(ex.getLocalizedMessage(), this.getLocation(), (Throwable)ex);
        }
    }

    public boolean isInvariant() {
        return false;
    }

    public String toString() {
        return String.format("OgnlBinding[%s]", this._expression);
    }
}

