/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.cache2k.Cache;
import org.cache2k.core.BulkOperationException;
import org.cache2k.core.BulkResultCollector;
import org.cache2k.core.EntryAction;
import org.cache2k.core.HeapCache;
import org.cache2k.core.api.InternalCache;
import org.cache2k.io.AsyncBulkCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheLoaderException;

public abstract class BulkAction<K, V, R>
implements AsyncCacheLoader<K, V>,
AsyncBulkCacheLoader.BulkCallback<K, V>,
EntryAction.CompletedCallback<K, V, R> {
    private final HeapCache<K, V> heapCache;
    final InternalCache<K, V> internalCache;
    private final Map<K, EntryAction<K, V, R>> key2action;
    private final Set<K> toLoad;
    private final AsyncCacheLoader<K, V> loader;
    private Collection<EntryAction<K, V, R>> toStart;
    private int completedCount = 0;
    private boolean completedCalled = false;

    public BulkAction(HeapCache<K, V> heapCache, InternalCache<K, V> internalCache, AsyncCacheLoader<K, V> loader, Set<K> keys) {
        this.heapCache = heapCache;
        this.internalCache = internalCache;
        this.loader = loader;
        this.key2action = new HashMap<K, EntryAction<K, V, R>>(keys.size());
        this.toLoad = new HashSet<K>(keys.size());
        this.toStart = new ArrayList<EntryAction<K, V, R>>(keys.size());
        for (K key : keys) {
            EntryAction<K, V, R> action = this.createEntryAction(key, this);
            this.toStart.add(action);
            this.key2action.put(key, action);
        }
    }

    public synchronized void start() {
        this.startRemaining();
        if (this.isSyncMode()) {
            this.loopIfSyncAndComplete();
        }
    }

    private void loopIfSyncAndComplete() {
        while (!this.toStart.isEmpty()) {
            this.startRemaining();
        }
        this.triggerComplete();
    }

    private void startRemaining() {
        while (!this.tryStartAllAndProcessPendingIo()) {
            if (!this.startSingleActionWithBlocking()) continue;
            return;
        }
    }

    private boolean tryStartAllAndProcessPendingIo() {
        if (this.toStart.size() == 1) {
            return false;
        }
        boolean someStarted = false;
        Iterator<EntryAction<K, V, R>> it = this.toStart.iterator();
        ArrayList<EntryAction<K, V, R>> rejected = new ArrayList<EntryAction<K, V, R>>(this.toStart.size());
        int alreadyCompleted = this.completedCount;
        while (it.hasNext()) {
            EntryAction<K, V, R> action = it.next();
            action.setBulkMode(true);
            try {
                action.start();
                someStarted = true;
            }
            catch (EntryAction.AbortWhenProcessingException e) {
                rejected.add(action);
            }
        }
        if (someStarted) {
            this.processPendingIo();
        }
        if (this.completedCount == this.key2action.size()) {
            this.triggerComplete();
            return true;
        }
        boolean allCompletedInSameThread = this.completedCount - alreadyCompleted == this.toStart.size() - rejected.size();
        this.toStart = rejected;
        boolean callbackPending = someStarted && !allCompletedInSameThread;
        return callbackPending;
    }

    private boolean startSingleActionWithBlocking() {
        int alreadyCompleted = this.completedCount;
        Iterator<EntryAction<K, V, R>> iterator = this.toStart.iterator();
        if (iterator.hasNext()) {
            EntryAction<K, V, R> action = iterator.next();
            action.setBulkMode(false);
            this.toStart.remove(action);
            action.start();
        }
        if (this.completedCount == this.key2action.size()) {
            this.triggerComplete();
            return true;
        }
        boolean callbackPending = alreadyCompleted == this.completedCount;
        return callbackPending;
    }

    private void processPendingIo() {
        if (!this.toLoad.isEmpty()) {
            this.startLoading();
        }
    }

    public void load(K key, AsyncCacheLoader.Context<K, V> context, AsyncCacheLoader.Callback<V> callback) throws Exception {
        if (((EntryAction)context).isBulkMode()) {
            this.toLoad.add(key);
        } else {
            this.loader.load(key, context, callback);
        }
    }

    private void startLoading() {
        if (this.loader instanceof AsyncBulkCacheLoader && this.toLoad.size() > 1) {
            this.startLoadingBulk();
        } else {
            this.startLoadingSingle();
        }
    }

    private void startLoadingSingle() {
        Iterator<K> it = this.toLoad.iterator();
        while (it.hasNext()) {
            K key = it.next();
            it.remove();
            EntryAction<K, V, R> action = this.key2action.get(key);
            try {
                this.loader.load(key, action, action);
            }
            catch (Throwable ouch) {
                action.onLoadFailure(ouch);
            }
        }
    }

    private void startLoadingBulk() {
        AsyncBulkCacheLoader bulkLoader = (AsyncBulkCacheLoader)this.loader;
        Set<K> keysCopy = Collections.unmodifiableSet(new HashSet<K>(this.toLoad));
        try {
            bulkLoader.loadAll(keysCopy, (AsyncBulkCacheLoader.BulkLoadContext)new MyBulkLoadContext(keysCopy, this), (AsyncBulkCacheLoader.BulkCallback)this);
        }
        catch (Throwable ouch) {
            this.onLoadFailure(ouch);
        }
    }

    public void onLoadSuccess(Map<? extends K, ? extends V> data) {
        for (Map.Entry<K, V> entry : data.entrySet()) {
            this.onLoadSuccessInternal(entry.getKey(), entry.getValue());
        }
    }

    public void onLoadSuccess(K key, V value) {
        this.onLoadSuccessInternal(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLoadSuccessInternal(K key, V value) {
        BulkAction bulkAction = this;
        synchronized (bulkAction) {
            this.expectKey(key);
        }
        EntryAction<K, V, R> action = this.key2action.get(key);
        action.onLoadSuccess(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoadFailure(Throwable exception) {
        HashSet<K> toLoadCopy;
        BulkAction bulkAction = this;
        synchronized (bulkAction) {
            toLoadCopy = new HashSet<K>(this.toLoad);
            this.toLoad.clear();
        }
        for (Object key : toLoadCopy) {
            EntryAction<K, V, R> action = this.key2action.get(key);
            action.onLoadFailure(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoadFailure(Iterable<? extends K> keys, Throwable exception) {
        HashSet<K> copy = new HashSet<K>();
        BulkAction bulkAction = this;
        synchronized (bulkAction) {
            for (K key : keys) {
                if (!this.toLoad.remove(key)) continue;
                copy.add(key);
            }
        }
        for (Object key : copy) {
            EntryAction<K, V, R> action = this.key2action.get(key);
            action.onLoadFailure(exception);
        }
    }

    public void expectKey(K key) {
        boolean present = this.toLoad.remove(key);
        if (!present) {
            throw new IllegalStateException("Callback key not part of request or already processed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoadFailure(K key, Throwable exception) {
        boolean present;
        BulkAction bulkAction = this;
        synchronized (bulkAction) {
            present = this.toLoad.remove(key);
        }
        if (!present) {
            return;
        }
        EntryAction<K, V, R> action = this.key2action.get(key);
        action.onLoadFailure(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entryActionCompleted(EntryAction<K, V, R> ea) {
        boolean sameThread = Thread.holdsLock(this);
        BulkAction bulkAction = this;
        synchronized (bulkAction) {
            boolean allCompletedThatWasStarted;
            ++this.completedCount;
            if (sameThread) {
                return;
            }
            int startedCount = this.key2action.size() - this.toStart.size();
            boolean bl = allCompletedThatWasStarted = this.completedCount == startedCount;
            if (allCompletedThatWasStarted) {
                if (!this.toStart.isEmpty()) {
                    this.startRemaining();
                } else {
                    this.triggerComplete();
                }
            }
        }
    }

    private void triggerComplete() {
        this.completedCalled = true;
        this.bulkOperationCompleted();
    }

    public Throwable getException() {
        Throwable exceptionToPropagate = this.getExceptionToPropagate();
        if (exceptionToPropagate != null) {
            return exceptionToPropagate;
        }
        return this.getLoaderException();
    }

    public Throwable getExceptionToPropagate() {
        RuntimeException exceptionToPropagate = null;
        int exceptionCount = 0;
        for (EntryAction<K, V, R> ea : this.key2action.values()) {
            RuntimeException exception = ea.getExceptionToPropagate();
            if (exception == null) continue;
            exceptionToPropagate = exception;
            ++exceptionCount;
        }
        if (exceptionCount > 1) {
            return new BulkOperationException(exceptionCount, this.key2action.size(), exceptionToPropagate);
        }
        return exceptionToPropagate;
    }

    public CacheLoaderException getLoaderException() {
        Throwable exceptionToPropagate = null;
        int exceptionCount = 0;
        for (EntryAction<K, V, R> ea : this.key2action.values()) {
            Throwable exception = ea.getLoaderException();
            if (exception == null) continue;
            exceptionToPropagate = exception;
            ++exceptionCount;
        }
        if (exceptionCount == 0) {
            return null;
        }
        return BulkResultCollector.createBulkLoaderException(exceptionCount, this.key2action.size(), exceptionToPropagate);
    }

    public Collection<EntryAction<K, V, R>> getActions() {
        return this.key2action.values();
    }

    protected void bulkOperationCompleted() {
    }

    protected abstract EntryAction<K, V, R> createEntryAction(K var1, BulkAction<K, V, R> var2);

    protected boolean isSyncMode() {
        return false;
    }

    private class MyBulkLoadContext
    implements AsyncBulkCacheLoader.BulkLoadContext<K, V> {
        private final Set<K> keys;
        private final AsyncBulkCacheLoader.BulkCallback<K, V> callback;
        private Map<K, AsyncCacheLoader.Context<K, V>> contextMap;

        MyBulkLoadContext(Set<K> keys, AsyncBulkCacheLoader.BulkCallback<K, V> callback) {
            this.keys = keys;
            this.callback = callback;
        }

        public Cache<K, V> getCache() {
            return BulkAction.this.internalCache.getUserCache();
        }

        public Map<K, AsyncCacheLoader.Context<K, V>> getContextMap() {
            if (this.contextMap == null) {
                this.contextMap = new HashMap(BulkAction.this.toLoad.size());
                for (Object key : this.keys) {
                    this.contextMap.put(key, (AsyncCacheLoader.Context)BulkAction.this.key2action.get(key));
                }
            }
            return this.contextMap;
        }

        public long getStartTime() {
            long t = Long.MAX_VALUE;
            for (Object key : this.keys) {
                t = Math.min(t, ((EntryAction)BulkAction.this.key2action.get(key)).getStartTime());
            }
            return t;
        }

        public Set<K> getKeys() {
            return this.keys;
        }

        public Executor getExecutor() {
            return BulkAction.this.heapCache.getExecutor();
        }

        public Executor getLoaderExecutor() {
            return BulkAction.this.heapCache.getLoaderExecutor();
        }

        public AsyncBulkCacheLoader.BulkCallback<K, V> getCallback() {
            return this.callback;
        }

        public boolean isRefreshAhead() {
            return false;
        }
    }
}

