/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.pyramid;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.transform.pyramid.PyramidDiscreteSampleBlur;
import boofcv.alg.transform.pyramid.PyramidFloatGaussianScale;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.PyramidDiscrete;
import boofcv.struct.pyramid.PyramidFloat;

public class FactoryPyramid {
    public static <T extends ImageBase<T>> PyramidDiscrete<T> discreteGaussian(ConfigDiscreteLevels configLevels, double sigma, int radius, boolean saveOriginalReference, ImageType<T> imageType) {
        Class kernelType = FactoryKernel.getKernelType(imageType.getDataType(), 1);
        Kernel1D kernel = (Kernel1D)FactoryKernelGaussian.gaussian(kernelType, sigma, radius);
        return new PyramidDiscreteSampleBlur<T>(kernel, sigma, imageType, saveOriginalReference, configLevels);
    }

    public static <T extends ImageGray<T>> PyramidFloat<T> floatGaussian(double[] scaleFactors, double[] sigmas, Class<T> imageType) {
        InterpolatePixelS<T> interp = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        return new PyramidFloatGaussianScale<T>(interp, scaleFactors, sigmas, imageType);
    }

    public static <T extends ImageGray<T>> PyramidFloat<T> scaleSpacePyramid(double[] scaleSpace, Class<T> imageType) {
        double[] sigmas = new double[scaleSpace.length];
        sigmas[0] = scaleSpace[0];
        for (int i = 1; i < scaleSpace.length; ++i) {
            double c = scaleSpace[i];
            double b = scaleSpace[i - 1];
            sigmas[i] = Math.sqrt(c * c - b * b);
            int n = i;
            sigmas[n] = sigmas[n] / scaleSpace[i - 1];
        }
        return FactoryPyramid.floatGaussian(scaleSpace, sigmas, imageType);
    }

    public static <T extends ImageGray<T>> PyramidFloat<T> scaleSpace(double[] scaleSpace, Class<T> imageType) {
        double[] scaleFactors = new double[scaleSpace.length];
        for (int i = 0; i < scaleSpace.length; ++i) {
            scaleFactors[i] = 1.0;
        }
        double[] sigmas = new double[scaleSpace.length];
        sigmas[0] = scaleSpace[0];
        for (int i = 1; i < scaleSpace.length; ++i) {
            double c = scaleSpace[i];
            double b = scaleSpace[i - 1];
            sigmas[i] = Math.sqrt(c * c - b * b);
        }
        return FactoryPyramid.floatGaussian(scaleFactors, sigmas, imageType);
    }
}

