/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding.impl;

import boofcv.core.encoding.ConvertYuv420_888;
import boofcv.misc.BoofMiscOps;
import java.nio.ByteBuffer;
import org.ddogleg.struct.DogArray_I8;
import pabeles.concurrency.GrowArray;

public class ImplConvertYuv420_888 {
    public static void processYuv(ByteBuffer bufferY, ByteBuffer bufferU, ByteBuffer bufferV, int width, int height, int strideY, int strideUV, int stridePixelUV, GrowArray<DogArray_I8> workArrays, ConvertYuv420_888.ProcessorYuv processor) {
        int periodUV = (int)Math.round((double)width / ((double)strideUV / (double)stridePixelUV));
        int workLength = strideY + strideUV + strideUV;
        workArrays.reset();
        byte[] work = BoofMiscOps.checkDeclare((DogArray_I8)((DogArray_I8)workArrays.grow()), (int)workLength, (boolean)false);
        int positionY = 0;
        int positionUV = 0;
        int rowBytesUV = (width / periodUV - 1) * stridePixelUV + 1;
        int offsetU = strideY;
        int offsetV = strideY + strideUV;
        int totalBytesY = bufferY.limit();
        int totalBytesU = bufferU.limit();
        int totalBytesV = bufferV.limit();
        int x = -1;
        int y = -1;
        int indexY = -1;
        int indexU = -1;
        int indexV = -1;
        try {
            for (y = 0; y < height; ++y) {
                bufferY.position(positionY);
                bufferY.get(work, 0, width);
                positionY += strideY;
                if (y % periodUV == 0) {
                    bufferU.position(positionUV);
                    bufferU.get(work, offsetU, rowBytesUV);
                    bufferV.position(positionUV);
                    bufferV.get(work, offsetV, rowBytesUV);
                    positionUV += strideUV;
                }
                indexY = 0;
                indexU = offsetU;
                indexV = offsetV;
                x = 0;
                while (x < width) {
                    processor.processYUV(work[indexY] & 0xFF, work[indexU] & 0xFF, work[indexV] & 0xFF);
                    int stepUV = stridePixelUV * ((x + 1) % periodUV == 0 ? 1 : 0);
                    indexU += stepUV;
                    indexV += stepUV;
                    ++x;
                    ++indexY;
                }
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "Crashed in YUV. " + e.getMessage() + " bytes Y=" + totalBytesY + " U=" + totalBytesU + " V=" + totalBytesV + " width=" + width + " height=" + height + " work.length=" + work.length + " strideY=" + strideY + " strideUV=" + strideUV + " stridePixelUV=" + stridePixelUV + " periodUV=" + periodUV + " x=" + x + " y=" + y + " indexY=" + indexY + " indexU=" + indexU + " indexV=" + indexV;
            throw new RuntimeException(message, e);
        }
    }
}

