/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.util;

import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;

public class XSNamedMapImpl
implements XSNamedMap {
    public static final XSNamedMap EMPTY_MAP = new XSNamedMap(){

        public int getLength() {
            return 0;
        }

        public XSObject itemByName(String namespace, String localName) {
            return null;
        }

        public XSObject item(int index) {
            return null;
        }
    };
    String[] fNamespaces;
    int fNSNum;
    SymbolHash[] fMaps;
    XSObject[] fArray = null;
    int fLength = -1;
    QName fName = new QName();

    public XSNamedMapImpl(String namespace, SymbolHash map) {
        this.fNamespaces = new String[]{namespace};
        this.fMaps = new SymbolHash[]{map};
        this.fNSNum = 1;
    }

    public XSNamedMapImpl(String[] namespaces, SymbolHash[] maps, int num) {
        this.fNamespaces = namespaces;
        this.fMaps = maps;
        this.fNSNum = num;
    }

    public XSNamedMapImpl(XSObject[] array, int length) {
        if (length == 0) {
            this.fNSNum = 0;
            this.fLength = 0;
            return;
        }
        this.fNamespaces = new String[]{array[0].getNamespace()};
        this.fMaps = null;
        this.fNSNum = 1;
        this.fArray = array;
        this.fLength = length;
    }

    public synchronized int getLength() {
        if (this.fLength == -1) {
            this.fLength = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                this.fLength += this.fMaps[i].getLength();
            }
        }
        return this.fLength;
    }

    public XSObject itemByName(String namespace, String localName) {
        for (int i = 0; i < this.fNSNum; ++i) {
            if (!this.isEqual(namespace, this.fNamespaces[i])) continue;
            if (this.fMaps != null) {
                return (XSObject)this.fMaps[i].get(localName);
            }
            for (int j = 0; j < this.fLength; ++j) {
                XSObject ret = this.fArray[j];
                if (!ret.getName().equals(localName)) continue;
                return ret;
            }
            return null;
        }
        return null;
    }

    public synchronized XSObject item(int index) {
        if (this.fArray == null) {
            this.getLength();
            this.fArray = new XSObject[this.fLength];
            int pos = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                pos += this.fMaps[i].getValues(this.fArray, pos);
            }
        }
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fArray[index];
    }

    final boolean isEqual(String one, String two) {
        return one != null ? one.equals(two) : two == null;
    }
}

