/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPath {
    String mainClass;
    boolean addDependencies = true;
    String jarLocation;
    String preCp;
    String postCp;

    private void addToCp(List cp, String cpStr) {
        cp.addAll(Arrays.asList(cpStr.split("\\s*;\\s*")));
    }

    net.sf.launch4j.config.ClassPath toL4j(Log log, Set<Artifact> dependencies) {
        net.sf.launch4j.config.ClassPath ret = new net.sf.launch4j.config.ClassPath();
        ret.setMainClass(this.mainClass);
        ArrayList<String> cp = new ArrayList<String>();
        if (this.preCp != null) {
            this.addToCp(cp, this.preCp);
        }
        if (this.addDependencies) {
            if (this.jarLocation == null) {
                this.jarLocation = "";
            } else if (!this.jarLocation.endsWith("/")) {
                this.jarLocation = this.jarLocation + "/";
            }
            for (Artifact dep : dependencies) {
                if (!"compile".equals(dep.getScope()) && !"runtime".equals(dep.getScope())) continue;
                String depFilename = dep.getFile().getName();
                if (depFilename.indexOf("SNAPSHOT") > 0) {
                    depFilename = this.snapshotArtifactFilename(dep, depFilename);
                    String originalName = dep.getFile().getName();
                    if (!originalName.equals(depFilename)) {
                        log.info((CharSequence)("Resolved SNAPSHOT JAR filename from " + originalName + " to " + depFilename));
                    }
                }
                cp.add(this.jarLocation + depFilename);
            }
        }
        if (this.postCp != null) {
            this.addToCp(cp, this.postCp);
        }
        ret.setPaths(cp);
        return ret;
    }

    protected String snapshotArtifactFilename(Artifact dep, String depFilename) {
        depFilename = depFilename.replaceAll("[\\d\\.]+?-SNAPSHOT", dep.getVersion());
        return depFilename;
    }
}

