/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.converter.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.converter.Converter;
import org.asciidoctor.converter.ConverterFor;
import org.asciidoctor.converter.OutputFormatWriter;
import org.asciidoctor.jruby.ast.impl.NodeConverter;
import org.asciidoctor.jruby.internal.RubyHashMapDecorator;
import org.asciidoctor.jruby.internal.RubyHashUtil;
import org.asciidoctor.jruby.internal.RubyOutputStreamWrapper;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ConverterProxy<T>
extends RubyObject {
    protected static final String METHOD_NAME_INITIALIZE = "initialize";
    private T output;
    private final Class<? extends Converter> converterClass;
    private Converter<T> delegate;

    public static <U, T extends Converter<U> & OutputFormatWriter<U>> RubyClass register(Ruby rubyRuntime, Class<T> converterClass) {
        RubyModule module = rubyRuntime.defineModule(ConverterProxy.getModuleName(converterClass));
        RubyClass clazz = module.defineClassUnder(converterClass.getSimpleName(), rubyRuntime.getObject(), (ObjectAllocator)new Allocator(converterClass));
        ConverterProxy.includeModule(clazz, "Asciidoctor", "Converter");
        ConverterProxy.includeModule(clazz, "Asciidoctor", "Converter", "BackendTraits");
        clazz.defineAnnotatedMethod(ConverterProxy.class, METHOD_NAME_INITIALIZE);
        clazz.defineAnnotatedMethod(ConverterProxy.class, "convert");
        ConverterProxy.includeModule(clazz, "Asciidoctor", "Writer");
        clazz.defineAnnotatedMethod(ConverterProxy.class, "write");
        return clazz;
    }

    public ConverterProxy(Ruby runtime, RubyClass metaClass, Class<? extends Converter> converterClass) {
        super(runtime, metaClass);
        this.converterClass = converterClass;
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args) {
        try {
            String backend = (String)JavaEmbedUtils.rubyToJava((Ruby)this.getRuntime(), (IRubyObject)args[0], String.class);
            Constructor<? extends Converter> constructor = this.converterClass.getConstructor(String.class, Map.class);
            this.delegate = constructor.newInstance(backend, args.length < 2 ? Collections.emptyMap() : new RubyHashMapDecorator((RubyHash)args[1]));
            RubyHash options = RubyHashUtil.convertMapToRubyHashWithSymbols(context.getRuntime(), this.delegate.getOptions());
            Helpers.invokeSuper((ThreadContext)context, (IRubyObject)this, (RubyModule)this.getMetaClass(), (String)METHOD_NAME_INITIALIZE, (IRubyObject[])new IRubyObject[]{args[0], options}, (Block)Block.NULL_BLOCK);
            String outfileSuffix = this.getOutfileSuffix();
            if (outfileSuffix != null) {
                this.callMethod(context, "outfilesuffix", (IRubyObject)this.getRuntime().newString(outfileSuffix));
            }
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private String getOutfileSuffix() {
        ConverterFor converterAnnotation;
        String outfileSuffix = this.delegate.getOutfileSuffix();
        if (outfileSuffix == null && this.delegate.getClass().getAnnotation(ConverterFor.class) != null && (converterAnnotation = this.delegate.getClass().getAnnotation(ConverterFor.class)).suffix() != "") {
            outfileSuffix = converterAnnotation.suffix();
            this.delegate.setOutfileSuffix(outfileSuffix);
        }
        return outfileSuffix;
    }

    @JRubyMethod(required=1, optional=2)
    public IRubyObject convert(ThreadContext context, IRubyObject[] args) {
        ContentNode node = NodeConverter.createASTNode(args[0]);
        Object ret = null;
        if (args.length == 1) {
            ret = this.delegate.convert(node, null, Collections.emptyMap());
        } else if (args.length == 2) {
            ret = this.delegate.convert(node, (String)JavaEmbedUtils.rubyToJava((Ruby)this.getRuntime(), (IRubyObject)args[1], String.class), Collections.emptyMap());
        } else if (args.length == 3) {
            ret = this.delegate.convert(node, (String)JavaEmbedUtils.rubyToJava((Ruby)this.getRuntime(), (IRubyObject)args[1], String.class), (Map)JavaEmbedUtils.rubyToJava((Ruby)this.getRuntime(), (IRubyObject)args[2], Map.class));
        }
        this.output = ret;
        return JavaEmbedUtils.javaToRuby((Ruby)this.getRuntime(), (Object)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod
    public IRubyObject write(ThreadContext context, IRubyObject output, IRubyObject target) throws IOException {
        OutputStream out = null;
        if (target instanceof JavaProxy) {
            JavaProxy javaProxy = (JavaProxy)target;
            if (!(javaProxy.getObject() instanceof OutputStream)) throw new IllegalArgumentException("Can't write to a " + javaProxy.getObject());
            out = (OutputStream)((JavaProxy)target).getObject();
        } else if (target instanceof RubyString) {
            File f = new File(((RubyString)target).asJavaString());
            out = new FileOutputStream(f);
        } else {
            if (!(target instanceof RubyOutputStreamWrapper)) throw new IllegalArgumentException("Can't write to a " + target);
            out = ((RubyOutputStreamWrapper)target).getOut();
        }
        if (out == null) return null;
        try {
            ((OutputFormatWriter)this.delegate).write(this.output, out);
            return null;
        }
        finally {
            out.close();
        }
    }

    private static void includeModule(RubyClass clazz, String moduleName, String ... moduleNames) {
        RubyModule module = clazz.getRuntime().getModule(moduleName);
        if (moduleNames != null && moduleNames.length > 0) {
            for (String submoduleName : moduleNames) {
                module = module.getModule(submoduleName);
            }
        }
        clazz.includeModule((IRubyObject)module);
    }

    private static String getModuleName(Class<?> converterClass) {
        StringBuilder sb = new StringBuilder();
        for (String s : converterClass.getPackage().getName().split("\\.")) {
            sb.append(s.substring(0, 1).toUpperCase()).append(s.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static class Allocator
    implements ObjectAllocator {
        private final Class<? extends Converter> converterClass;

        public Allocator(Class<? extends Converter> converterClass) {
            this.converterClass = converterClass;
        }

        public IRubyObject allocate(Ruby runtime, RubyClass rubyClass) {
            return new ConverterProxy(runtime, rubyClass, this.converterClass);
        }

        public Class<? extends Converter> getConverterClass() {
            return this.converterClass;
        }
    }
}

