/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Scanner;
import java.util.StringJoiner;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.asciidoctor.maven.AsciidoctorMojo;
import org.asciidoctor.maven.refresh.AbstractFileAlterationListenerAdaptor;
import org.asciidoctor.maven.refresh.AsciidoctorConverterFileAlterationListenerAdaptor;
import org.asciidoctor.maven.refresh.ResourceCopyFileAlterationListenerAdaptor;
import org.asciidoctor.maven.refresh.ResourcesPatternBuilder;
import org.asciidoctor.maven.refresh.TimeCounter;

@Mojo(name="auto-refresh")
public class AsciidoctorRefreshMojo
extends AsciidoctorMojo {
    public static final String PREFIX = "asciidoctor.refresher.";
    @Parameter(property="asciidoctor.refresher.interval")
    protected int interval = 2000;
    private Collection<FileAlterationMonitor> monitors = null;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.startPolling();
        this.doWork();
        this.doWait();
        this.stopMonitors();
    }

    protected void doWork() {
        long timeInMillis = TimeCounter.timed(() -> {
            try {
                this.processAllSources(this.defaultResourcesProcessor);
            }
            catch (MojoExecutionException e) {
                this.getLog().error((Throwable)e);
            }
        });
        this.getLog().info((CharSequence)("Converted document(s) in " + timeInMillis + "ms"));
    }

    protected void doWait() {
        String line;
        this.showWaitMessage();
        Scanner scanner = new Scanner(System.in);
        while ((line = scanner.nextLine()) != null) {
            if ("exit".equalsIgnoreCase(line = line.trim()) || "quit".equalsIgnoreCase(line)) {
                return;
            }
            if ("refresh".equalsIgnoreCase(line)) {
                this.doWork();
                continue;
            }
            this.getLog().warn((CharSequence)("'" + line + "' not understood, available commands are [quit, exit, refresh]."));
        }
    }

    private void showWaitMessage() {
        this.getLog().info((CharSequence)"Type [exit|quit] to exit and [refresh] to force a manual re-conversion.");
    }

    protected void stopMonitors() throws MojoExecutionException {
        if (this.monitors != null) {
            for (FileAlterationMonitor monitor : this.monitors) {
                try {
                    monitor.stop();
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            }
        }
    }

    protected void startPolling() throws MojoExecutionException {
        Optional<File> sourceDirectoryCandidate = this.findSourceDirectory(this.sourceDirectory, this.project.getBasedir());
        if (!sourceDirectoryCandidate.isPresent()) {
            this.getLog().info((CharSequence)"No sourceDirectory found. Skipping processing");
            return;
        }
        File sourceDirectory = sourceDirectoryCandidate.get();
        FileAlterationMonitor fileAlterationMonitor = new FileAlterationMonitor((long)this.interval);
        FileAlterationObserver observer = new FileAlterationObserver(sourceDirectory, (FileFilter)this.buildSourcesFileFilter());
        AbstractFileAlterationListenerAdaptor listener = new AsciidoctorConverterFileAlterationListenerAdaptor(this, () -> this.showWaitMessage(), this.getLog());
        observer.addListener((FileAlterationListener)listener);
        fileAlterationMonitor.addObserver(observer);
        observer = new FileAlterationObserver(sourceDirectory, this.buildResourcesFileFilter());
        listener = new ResourceCopyFileAlterationListenerAdaptor(this, () -> this.showWaitMessage(), this.getLog());
        observer.addListener((FileAlterationListener)listener);
        fileAlterationMonitor.addObserver(observer);
        this.monitors = Collections.singletonList(fileAlterationMonitor);
        for (FileAlterationMonitor monitor : this.monitors) {
            try {
                monitor.start();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private FileFilter buildResourcesFileFilter() {
        String resourcesRegexPattern = new ResourcesPatternBuilder(this.sourceDocumentName, this.sourceDocumentExtensions).build();
        return FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), new RegexFileFilter(resourcesRegexPattern)});
    }

    private IOFileFilter buildSourcesFileFilter() {
        if (!StringUtils.isBlank((CharSequence)this.sourceDocumentName)) {
            return new NameFileFilter(this.sourceDocumentName);
        }
        if (!this.sourceDocumentExtensions.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner("|", "^[^_.].*\\.(", ")$");
            for (String extension : this.sourceDocumentExtensions) {
                stringJoiner.add(extension);
            }
            return FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), new RegexFileFilter(stringJoiner.toString())});
        }
        return FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), new RegexFileFilter("^[^_.].*\\.a((sc(iidoc)?)|d(oc)?)$")});
    }
}

