/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.str;

import java.util.List;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.dom.message.token.PKIPathSecurity;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.message.token.X509Security;
import org.apache.wss4j.dom.processor.Processor;
import org.w3c.dom.Element;

public final class STRParserUtil {
    private STRParserUtil() {
    }

    public static SamlAssertionWrapper getAssertionFromKeyIdentifier(SecurityTokenReference secRef, Element strElement, RequestData request, WSDocInfo wsDocInfo) throws WSSecurityException {
        String keyIdentifierValue = secRef.getKeyIdentifierValue();
        String type = secRef.getKeyIdentifierValueType();
        WSSecurityEngineResult result = wsDocInfo.getResult(keyIdentifierValue);
        SamlAssertionWrapper samlAssertion = null;
        Element token = null;
        if (result != null) {
            samlAssertion = (SamlAssertionWrapper)result.get("saml-assertion");
            return samlAssertion;
        }
        token = secRef.findProcessedTokenElement(strElement.getOwnerDocument(), wsDocInfo, request.getCallbackHandler(), keyIdentifierValue, type);
        if (token != null) {
            if (!"Assertion".equals(token.getLocalName())) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
            }
            return new SamlAssertionWrapper(token);
        }
        token = secRef.findUnprocessedTokenElement(strElement.getOwnerDocument(), wsDocInfo, request.getCallbackHandler(), keyIdentifierValue, type);
        if (token == null || !"Assertion".equals(token.getLocalName())) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[0]);
        }
        Processor proc = request.getWssConfig().getProcessor(WSSecurityEngine.SAML_TOKEN);
        List<WSSecurityEngineResult> samlResult = proc.handleToken(token, request, wsDocInfo);
        return (SamlAssertionWrapper)samlResult.get(0).get("saml-assertion");
    }

    public static void checkBinarySecurityBSPCompliance(SecurityTokenReference secRef, BinarySecurity token, BSPEnforcer bspEnforcer) throws WSSecurityException {
        String tokenType;
        String valueType;
        if (secRef.containsReference()) {
            valueType = secRef.getReference().getValueType();
            if (token instanceof X509Security && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType) || token instanceof PKIPathSecurity && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1".equals(valueType) || token instanceof KerberosSecurity && valueType != null && !"".equals(valueType) && !"http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(valueType)) {
                bspEnforcer.handleBSPRule(BSPRule.R3058);
            }
        } else if (secRef.containsKeyIdentifier() && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(valueType = secRef.getKeyIdentifierValueType()) && !"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(valueType) && !"http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(valueType)) {
            bspEnforcer.handleBSPRule(BSPRule.R3063);
        }
        if (token instanceof PKIPathSecurity && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1".equals(tokenType = secRef.getTokenType())) {
            bspEnforcer.handleBSPRule(BSPRule.R5215);
        }
    }

    public static void checkEncryptedKeyBSPCompliance(SecurityTokenReference secRef, BSPEnforcer bspEnforcer) throws WSSecurityException {
        String tokenType;
        String valueType;
        if (secRef.containsKeyIdentifier() && !"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(valueType = secRef.getKeyIdentifierValueType())) {
            bspEnforcer.handleBSPRule(BSPRule.R3063);
        }
        if (!"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(tokenType = secRef.getTokenType())) {
            bspEnforcer.handleBSPRule(BSPRule.R5215);
        }
    }

    public static void checkSamlTokenBSPCompliance(SecurityTokenReference secRef, SamlAssertionWrapper samlAssertion, BSPEnforcer bspEnforcer) throws WSSecurityException {
        String valueType;
        if (secRef.containsKeyIdentifier()) {
            String encoding;
            String valueType2 = secRef.getKeyIdentifierValueType();
            if (samlAssertion.getSaml1() != null && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType2)) {
                bspEnforcer.handleBSPRule(BSPRule.R6603);
            }
            if (samlAssertion.getSaml2() != null && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType2)) {
                bspEnforcer.handleBSPRule(BSPRule.R6616);
            }
            if ((encoding = secRef.getKeyIdentifierEncodingType()) != null && !"".equals(encoding)) {
                bspEnforcer.handleBSPRule(BSPRule.R6604);
            }
        }
        String tokenType = secRef.getTokenType();
        if (samlAssertion.getSaml1() != null && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            bspEnforcer.handleBSPRule(BSPRule.R6611);
        }
        if (samlAssertion.getSaml2() != null && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType)) {
            bspEnforcer.handleBSPRule(BSPRule.R6617);
        }
        if (samlAssertion.getSaml2() != null && secRef.containsReference() && (valueType = secRef.getReference().getValueType()) != null && !"".equals(valueType)) {
            bspEnforcer.handleBSPRule(BSPRule.R6614);
        }
    }

    public static void checkUsernameTokenBSPCompliance(SecurityTokenReference secRef, BSPEnforcer bspEnforcer) throws WSSecurityException {
        String valueType;
        if (!secRef.containsReference()) {
            bspEnforcer.handleBSPRule(BSPRule.R4215);
        }
        if (secRef.getReference() != null && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken".equals(valueType = secRef.getReference().getValueType())) {
            bspEnforcer.handleBSPRule(BSPRule.R4214);
        }
    }
}

