/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

public class FormAuthenticator
extends AuthenticatorBase {
    private static Log log = LogFactory.getLog(FormAuthenticator.class);
    protected static final String info = "org.apache.catalina.authenticator.FormAuthenticator/1.0";
    protected String characterEncoding = null;

    public String getInfo() {
        return info;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public boolean authenticate(Request request, Response response, LoginConfig config) throws IOException {
        boolean loginAction;
        Session session = null;
        Principal principal = request.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (ssoId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SSO Id " + ssoId + " set; attempting " + "reauthentication"));
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        if (!this.cache) {
            session = request.getSessionInternal(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for reauthenticate in session " + session));
            }
            String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            String password = (String)session.getNote("org.apache.catalina.session.PASSWORD");
            if (username != null && password != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reauthenticating username '" + username + "'"));
                }
                if ((principal = this.context.getRealm().authenticate(username, password)) != null) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
                    if (!this.matchRequest(request)) {
                        this.register(request, response, principal, "FORM", username, password);
                        return true;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(request)) {
            session = request.getSessionInternal(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restore request from session '" + session.getIdInternal() + "'"));
            }
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.register(request, response, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (String)session.getNote("org.apache.catalina.session.PASSWORD"));
            if (this.cache) {
                session.removeNote("org.apache.catalina.session.USERNAME");
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
            if (this.restoreRequest(request, session)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Proceed to restored request");
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Restore of original request failed");
            }
            response.sendError(400);
            return false;
        }
        MessageBytes uriMB = MessageBytes.newInstance();
        CharChunk uriCC = uriMB.getCharChunk();
        uriCC.setLimit(-1);
        String contextPath = request.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        response.setContext(request.getContext());
        boolean bl = loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        if (!loginAction) {
            session = request.getSessionInternal(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Save request in session '" + session.getIdInternal() + "'"));
            }
            try {
                this.saveRequest(request, session);
            }
            catch (IOException ioe) {
                log.debug((Object)"Request body too big to save during authentication");
                response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                return false;
            }
            this.forwardToLoginPage(request, response, config);
            return false;
        }
        response.sendAcknowledgement();
        Realm realm = this.context.getRealm();
        if (this.characterEncoding != null) {
            request.setCharacterEncoding(this.characterEncoding);
        }
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authenticating username '" + username + "'"));
        }
        if ((principal = realm.authenticate(username, password)) == null) {
            this.forwardToErrorPage(request, response, config);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication of '" + username + "' was successful"));
        }
        if (session == null) {
            session = request.getSessionInternal(false);
        }
        if (session == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"User took so long to log on the session expired");
            }
            response.sendError(408, sm.getString("authenticator.sessionExpired"));
            return false;
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        session.setNote("org.apache.catalina.session.USERNAME", username);
        session.setNote("org.apache.catalina.session.PASSWORD", password);
        requestURI = this.savedRequestURL(session);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting to original '" + requestURI + "'"));
        }
        if (requestURI == null) {
            response.sendError(400, sm.getString("authenticator.formlogin"));
        } else {
            response.sendRedirect(response.encodeRedirectURL(requestURI));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardToLoginPage(Request request, Response response, LoginConfig config) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("formAuthenticator.forwardLogin", request.getRequestURI(), request.getMethod(), config.getLoginPage(), this.context.getName()));
        }
        String oldMethod = request.getCoyoteRequest().method().toString();
        request.getCoyoteRequest().method().setString("GET");
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getLoginPage());
        try {
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
            response.finishResponse();
        }
        catch (Throwable t) {
            String msg = sm.getString("formAuthenticator.forwardLoginFail");
            log.warn((Object)msg, t);
            request.setAttribute("javax.servlet.error.exception", t);
            response.sendError(500, msg);
        }
        finally {
            request.getCoyoteRequest().method().setString(oldMethod);
        }
    }

    protected void forwardToErrorPage(Request request, Response response, LoginConfig config) throws IOException {
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(config.getErrorPage());
        try {
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
        }
        catch (Throwable t) {
            String msg = sm.getString("formAuthenticator.forwardErrorFail");
            log.warn((Object)msg, t);
            request.setAttribute("javax.servlet.error.exception", t);
            response.sendError(500, msg);
        }
    }

    protected boolean matchRequest(Request request) {
        Session session = request.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        SavedRequest sreq = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (sreq == null) {
            return false;
        }
        if (session.getNote("org.apache.catalina.authenticator.PRINCIPAL") == null) {
            return false;
        }
        String decodedRequestURI = request.getDecodedRequestURI();
        if (decodedRequestURI == null) {
            return false;
        }
        return decodedRequestURI.equals(sreq.getDecodedRequestURI());
    }

    protected boolean restoreRequest(Request request, Session session) throws IOException {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
        if (saved == null) {
            return false;
        }
        request.clearCookies();
        Iterator cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie((Cookie)cookies.next());
        }
        String method = saved.getMethod();
        MimeHeaders rmh = request.getCoyoteRequest().getMimeHeaders();
        rmh.recycle();
        boolean cachable = "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
        Iterator names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            if ("If-Modified-Since".equalsIgnoreCase(name) || cachable && "If-None-Match".equalsIgnoreCase(name)) continue;
            Iterator values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                rmh.addValue(name).setString((String)values.next());
            }
        }
        request.clearLocales();
        Iterator locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale((Locale)locales.next());
        }
        request.getCoyoteRequest().getParameters().recycle();
        request.getCoyoteRequest().getParameters().setQueryStringEncoding(request.getConnector().getURIEncoding());
        ByteChunk body = saved.getBody();
        if (body != null) {
            request.getCoyoteRequest().action(ActionCode.ACTION_REQ_SET_BODY_REPLAY, (Object)body);
            MessageBytes contentType = MessageBytes.newInstance();
            String savedContentType = saved.getContentType();
            if (savedContentType == null && "POST".equalsIgnoreCase(method)) {
                savedContentType = "application/x-www-form-urlencoded";
            }
            contentType.setString(savedContentType);
            request.getCoyoteRequest().setContentType(contentType);
        }
        request.getCoyoteRequest().method().setString(method);
        request.getCoyoteRequest().queryString().setString(saved.getQueryString());
        request.getCoyoteRequest().requestURI().setString(saved.getRequestURI());
        return true;
    }

    protected void saveRequest(Request request, Session session) throws IOException {
        int bytesRead;
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                saved.addCookie(cookies[i]);
            }
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            saved.addLocale(locale);
        }
        request.getResponse().sendAcknowledgement();
        ByteChunk body = new ByteChunk();
        body.setLimit(request.getConnector().getMaxSavePostSize());
        byte[] buffer = new byte[4096];
        ServletInputStream is = request.getInputStream();
        while ((bytesRead = is.read(buffer)) >= 0) {
            body.append(buffer, 0, bytesRead);
        }
        if (body.getLength() > 0) {
            saved.setContentType(request.getContentType());
            saved.setBody(body);
        }
        saved.setMethod(request.getMethod());
        saved.setQueryString(request.getQueryString());
        saved.setRequestURI(request.getRequestURI());
        saved.setDecodedRequestURI(request.getDecodedRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            sb.append('?');
            sb.append(saved.getQueryString());
        }
        return sb.toString();
    }
}

