/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.route.context.RouteMapper;

public final class RouteUnit {
    private final RouteMapper dataSourceMapper;
    private final Collection<RouteMapper> tableMappers;

    public Set<String> getLogicTableNames() {
        return this.tableMappers.stream().map(RouteMapper::getLogicName).collect(Collectors.toCollection(() -> new HashSet(this.tableMappers.size(), 1.0f)));
    }

    public Set<String> getActualTableNames(String logicTableName) {
        return this.tableMappers.stream().filter(each -> logicTableName.equalsIgnoreCase(each.getLogicName())).map(RouteMapper::getActualName).collect(Collectors.toSet());
    }

    public Optional<RouteMapper> findTableMapper(String logicDataSourceName, String actualTableName) {
        for (RouteMapper each : this.tableMappers) {
            if (!logicDataSourceName.equalsIgnoreCase(this.dataSourceMapper.getLogicName()) || !actualTableName.equalsIgnoreCase(each.getActualName())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    @Generated
    public RouteUnit(RouteMapper dataSourceMapper, Collection<RouteMapper> tableMappers) {
        this.dataSourceMapper = dataSourceMapper;
        this.tableMappers = tableMappers;
    }

    @Generated
    public RouteMapper getDataSourceMapper() {
        return this.dataSourceMapper;
    }

    @Generated
    public Collection<RouteMapper> getTableMappers() {
        return this.tableMappers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouteUnit)) {
            return false;
        }
        RouteUnit other = (RouteUnit)o;
        RouteMapper this$dataSourceMapper = this.getDataSourceMapper();
        RouteMapper other$dataSourceMapper = other.getDataSourceMapper();
        if (this$dataSourceMapper == null ? other$dataSourceMapper != null : !((Object)this$dataSourceMapper).equals(other$dataSourceMapper)) {
            return false;
        }
        Collection<RouteMapper> this$tableMappers = this.getTableMappers();
        Collection<RouteMapper> other$tableMappers = other.getTableMappers();
        return !(this$tableMappers == null ? other$tableMappers != null : !((Object)this$tableMappers).equals(other$tableMappers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RouteMapper $dataSourceMapper = this.getDataSourceMapper();
        result = result * 59 + ($dataSourceMapper == null ? 43 : ((Object)$dataSourceMapper).hashCode());
        Collection<RouteMapper> $tableMappers = this.getTableMappers();
        result = result * 59 + ($tableMappers == null ? 43 : ((Object)$tableMappers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RouteUnit(dataSourceMapper=" + this.getDataSourceMapper() + ", tableMappers=" + this.getTableMappers() + ")";
    }
}

