/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.expr.literal;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.shardingsphere.infra.expr.spi.InlineExpressionParser;

public final class LiteralInlineExpressionParser
implements InlineExpressionParser {
    private static final char SPLITTER = ',';
    private String inlineExpression;

    public void init(Properties props) {
        this.inlineExpression = props.getProperty("inlineExpression");
    }

    public List<String> splitAndEvaluate() {
        return Strings.isNullOrEmpty((String)this.inlineExpression) ? Collections.emptyList() : this.split(this.inlineExpression);
    }

    private List<String> split(String inlineExpression) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder segment = new StringBuilder();
        for (int i = 0; i < inlineExpression.length(); ++i) {
            char each = inlineExpression.charAt(i);
            if (',' == each) {
                result.add(segment.toString().trim());
                segment.setLength(0);
                continue;
            }
            segment.append(each);
        }
        if (segment.length() > 0) {
            result.add(segment.toString().trim());
        }
        return result;
    }

    public String getType() {
        return "LITERAL";
    }
}

