/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.util.Enumeration;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;

public class SimpleAttributeTest
extends AbstractReflectivePortletTest {
    private static final String KEY = "org.apache.pluto.testsuite.BOGUS_KEY";
    private static final String VAL = "! TEST VAL !";

    protected TestResult checkGetNullAttribute(PortletRequest req) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that if an attribute bound to an invalid key is retrieved, null is returned.");
        Object val = req.getAttribute(KEY);
        if (val == null) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"unbound attribute", (Object)val, null, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkSetAttribute(PortletRequest req) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that attributes can be set to portlet request.");
        req.setAttribute(KEY, (Object)VAL);
        Object val = req.getAttribute(KEY);
        if (VAL.equals(val)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"attribute", (Object)val, (Object)VAL, (TestResult)result);
        }
        req.removeAttribute(KEY);
        return result;
    }

    protected TestResult checkRemoveAttribute(PortletRequest req) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that attributes can be removed from portlet request.");
        req.setAttribute(KEY, (Object)VAL);
        req.removeAttribute(KEY);
        Object val = req.getAttribute(KEY);
        if (val == null) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"removed attribute", (Object)val, null, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkEnumerateAttributes(PortletRequest req) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that all attribute names appear in the attribute name enumeration returned by portlet request.");
        int count = 5;
        for (int i = 0; i < count; ++i) {
            req.setAttribute("org.apache.pluto.testsuite.BOGUS_KEY." + i, (Object)VAL);
        }
        int found = 0;
        Enumeration en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            if (!((String)en.nextElement()).toString().startsWith(KEY)) continue;
            ++found;
        }
        if (count == found) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"count of attribute names", (Object)String.valueOf(found), (Object)String.valueOf(count), (TestResult)result);
        }
        return result;
    }

    protected TestResult checkGetNullAttribute(PortletSession session) {
        TestResult res = new TestResult();
        res.setName("Retrieve Missing Session Attribute Test");
        res.setDescription("Retrieves an attribute bound to an invalid key set are retrieved as null");
        Object val = session.getAttribute(KEY);
        if (val != null) {
            res.setReturnCode(1);
            res.setResultMessage("Retrieved value: '" + val + "' for attribute '" + KEY + "'");
        } else {
            res.setReturnCode(2);
        }
        return res;
    }

    protected TestResult checkSetAttribute(PortletSession session) {
        TestResult res = new TestResult();
        res.setName("Set Attribute Test");
        res.setDescription("Sets and retrieves portlet sessionuest attribute.");
        session.setAttribute(KEY, (Object)VAL);
        Object val = session.getAttribute(KEY);
        if (!VAL.equals(val)) {
            res.setReturnCode(1);
            res.setResultMessage("Retrieved value: '" + val + "' - Expected '" + VAL + "'");
        } else {
            res.setReturnCode(2);
        }
        session.removeAttribute(KEY);
        return res;
    }

    protected TestResult checkRemoveAttribute(PortletSession session) {
        TestResult res = new TestResult();
        res.setName("Remove Session Attribute Test");
        res.setDescription("Sets, removes and retrieves portlet request attribute.");
        session.setAttribute(KEY, (Object)VAL);
        session.removeAttribute(KEY);
        Object val = session.getAttribute(KEY);
        if (val != null) {
            res.setReturnCode(1);
            res.setResultMessage("Retrieved value: '" + val + "' - Expected '" + VAL + "'");
        } else {
            res.setReturnCode(2);
        }
        return res;
    }

    protected TestResult checkEnumerateAttributes(PortletSession session) {
        TestResult result = new TestResult();
        result.setDescription("Sets session attributes and enumerates over them.");
        int count = 5;
        for (int i = 0; i < count; ++i) {
            session.setAttribute("org.apache.pluto.testsuite.BOGUS_KEY." + i, (Object)VAL);
        }
        int found = 0;
        Enumeration en = session.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!name.startsWith(KEY)) continue;
            ++found;
        }
        if (count != found) {
            result.setReturnCode(1);
            result.setResultMessage("Expected " + count + " attributes. " + "Found " + found);
        } else {
            result.setReturnCode(2);
        }
        return result;
    }

    protected TestResult checkGetNullAttribute(PortletContext context) {
        TestResult res = new TestResult();
        res.setName("Retrieve Missing Context Attribute Test");
        res.setDescription("Retrieves an attribute bound to an invalid key set are retrieved as null");
        Object val = context.getAttribute(KEY);
        if (val != null) {
            res.setReturnCode(1);
            res.setResultMessage("Retrieved value: '" + val + "' for attribute '" + KEY + "'");
        } else {
            res.setReturnCode(2);
        }
        return res;
    }

    protected TestResult checkSetAttribute(PortletContext context) {
        TestResult res = new TestResult();
        res.setName("Set Attribute Test");
        res.setDescription("Sets and retrieves portlet contextuest attribute.");
        context.setAttribute(KEY, (Object)VAL);
        Object val = context.getAttribute(KEY);
        if (!VAL.equals(val)) {
            res.setReturnCode(1);
            res.setResultMessage("Retrieved value: '" + val + "' - Expected '" + VAL + "'");
        } else {
            res.setReturnCode(2);
        }
        context.removeAttribute(KEY);
        return res;
    }

    protected TestResult checkRemoveAttribute(PortletContext context) {
        TestResult res = new TestResult();
        res.setName("Remove Context Attribute Test");
        res.setDescription("Sets, removes and retrieves portlet request attribute.");
        context.setAttribute(KEY, (Object)VAL);
        context.removeAttribute(KEY);
        Object val = context.getAttribute(KEY);
        if (val != null) {
            res.setReturnCode(1);
            res.setResultMessage("Retrieved value: '" + val + "' - Expected '" + VAL + "'");
        } else {
            res.setReturnCode(2);
        }
        return res;
    }

    protected TestResult checkEnumerateAttributesInContext(PortletContext context) {
        TestResult result = new TestResult();
        result.setDescription("Sets attributes in portlet context and enumerates over them.");
        int count = 5;
        for (int i = 0; i < count; ++i) {
            context.setAttribute("org.apache.pluto.testsuite.BOGUS_KEY." + i, (Object)VAL);
        }
        int found = 0;
        Enumeration en = context.getAttributeNames();
        while (en.hasMoreElements()) {
            if (!en.nextElement().toString().startsWith(KEY)) continue;
            ++found;
        }
        if (count == found) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Expected " + count + " attributes. " + "Found " + found);
        }
        return result;
    }
}

