/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.pluto.testsuite.InvalidConfigurationException;

public class ExpectedResults {
    public static final String PROPERTY_FILENAME = "expectedResults.properties";
    private static ExpectedResults instance;
    private Properties properties = new Properties();

    private ExpectedResults() throws IOException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTY_FILENAME);
        if (in == null) {
            throw new IOException("Could not find expectedResults.properties");
        }
        this.properties.load(in);
    }

    public static ExpectedResults getInstance() throws InvalidConfigurationException {
        if (instance == null) {
            try {
                instance = new ExpectedResults();
            }
            catch (IOException ex) {
                throw new InvalidConfigurationException("Error reading file expectedResults.properties: " + ex.getMessage());
            }
        }
        return instance;
    }

    public String getMajorVersion() {
        return this.properties.getProperty("expected.version.major");
    }

    public String getMinorVersion() {
        return this.properties.getProperty("expected.version.minor");
    }

    public String getServerInfo() {
        return this.properties.getProperty("expected.serverInfo");
    }

    public String getPortalInfo() {
        return this.properties.getProperty("expected.portalInfo");
    }

    public String getMappedSecurityRole() {
        return this.properties.getProperty("expected.security.role.mapped");
    }

    public String getUnmappedSecurityRole() {
        return this.properties.getProperty("expected.security.role");
    }
}

