/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import org.apache.pluto.testsuite.NoOpTest;
import org.apache.pluto.testsuite.PortletTest;
import org.apache.pluto.testsuite.TestConfig;
import org.apache.pluto.testsuite.TestConfigFactory;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPortlet
extends GenericPortlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestPortlet.class);
    private List<TestConfig> testConfigs;
    private Map<String, PortletTest> tests;

    public void init() throws PortletException {
        InputStream is;
        String configFile = this.getInitParameter("config");
        if (configFile == null) {
            configFile = "/WEB-INF/testsuite-config.xml";
        }
        if ((is = this.getPortletContext().getResourceAsStream(configFile)) == null) {
            String message = "Testsuite configuration file not found.";
            LOG.error(message);
            throw new PortletException(message);
        }
        TestConfigFactory factory = new TestConfigFactory();
        try {
            this.testConfigs = factory.createTestConfigs(is);
            this.tests = new HashMap();
            int i = 0;
            for (TestConfig testConfig : this.testConfigs) {
                String name = testConfig.getTestClassName();
                NoOpTest test = null;
                if (name != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Loading test: " + name);
                    }
                    Class<?> clazz = Class.forName(testConfig.getTestClassName());
                    test = (PortletTest)clazz.newInstance();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Loading NoOpTest (test with no name).");
                    }
                    test = new NoOpTest();
                }
                test.init(testConfig);
                this.tests.put(String.valueOf(i++), test);
            }
        }
        catch (Throwable th) {
            String message = "Unable to read testsuite configuration.";
            LOG.error(message, th);
            throw new PortletException(message, th);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.processStateAwarePhase((PortletRequest)request, (StateAwareResponse)response);
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        String testId;
        PortletTest test;
        if (PortletMode.VIEW.equals((Object)request.getPortletMode()) && (test = (PortletTest)this.tests.get(testId = this.getTestId((PortletRequest)request))) != null) {
            test.doHeaders(this.getPortletConfig(), this.getPortletContext(), request, response);
        }
    }

    private void processStateAwarePhase(PortletRequest request, StateAwareResponse response) {
        String testId = this.getTestId(request);
        PortletTest test = (PortletTest)this.tests.get(testId);
        if (test != null) {
            TestResults results = test.doTest(this.getPortletConfig(), this.getPortletContext(), request, (PortletResponse)response);
            PortletSession session = request.getPortletSession();
            TestResults existingResults = (TestResults)session.getAttribute(test.getClass().getName());
            if (existingResults != null) {
                for (TestResult result : results.getCollection()) {
                    existingResults.add(result);
                }
            } else {
                session.setAttribute(test.getClass().getName(), (Object)results);
            }
        }
        HashMap<String, String[]> renderParameters = null;
        if (test != null) {
            renderParameters = test.getRenderParameters(request);
        }
        if (renderParameters == null) {
            renderParameters = new HashMap<String, String[]>();
        }
        renderParameters.put("testId", new String[]{testId});
        response.setRenderParameters(renderParameters);
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        this.processStateAwarePhase((PortletRequest)request, (StateAwareResponse)response);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        String testId = this.getTestId((PortletRequest)request);
        PortletTest test = (PortletTest)this.tests.get(testId);
        if (test != null) {
            TestResults results = test.doTest(this.getPortletConfig(), this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
            PortletSession session = request.getPortletSession();
            TestResults existing = (TestResults)session.getAttribute(test.getClass().getName());
            if (existing != null) {
                for (TestResult result : results.getCollection()) {
                    existing.add(result);
                }
                request.setAttribute("results", (Object)existing);
                session.setAttribute(test.getClass().getName(), null);
            } else {
                request.setAttribute("results", (Object)results);
            }
        }
        if (test.getConfig().getDisplayURI().indexOf("load_resource_test") > -1) {
            response.setContentType("text/html");
            this.getPortletContext().getRequestDispatcher("/jsp/test_results.jsp").include((PortletRequest)request, (PortletResponse)response);
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String testId = this.getTestId((PortletRequest)request);
        TestConfig testConfig = null;
        PortletTest test = null;
        if (testId != null) {
            testConfig = (TestConfig)this.testConfigs.get(Integer.parseInt(testId));
            test = (PortletTest)this.tests.get(testId);
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry e : request.getParameterMap().entrySet()) {
                LOG.debug((String)e.getKey() + " => " + Arrays.asList((Object[])e.getValue()));
            }
            LOG.debug("Test ID: " + testId);
            LOG.debug("Test Config: " + testConfig);
            if (testConfig != null) {
                LOG.debug("Test config view: " + testConfig.getDisplayURI());
            }
        }
        if (test != null) {
            TestResults results = test.doTest(this.getPortletConfig(), this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
            PortletSession session = request.getPortletSession();
            TestResults existing = (TestResults)session.getAttribute(test.getClass().getName());
            if (existing != null) {
                for (TestResult result : results.getCollection()) {
                    existing.add(result);
                }
                request.setAttribute("results", (Object)existing);
                session.setAttribute(test.getClass().getName(), null);
            } else {
                request.setAttribute("results", (Object)results);
            }
        }
        if (testId == null) {
            request.setAttribute("testConfigs", (Object)this.testConfigs);
        } else {
            TestConfig nextTestConfig = null;
            TestConfig prevTestConfig = null;
            int index = this.testConfigs.indexOf(test.getConfig());
            if (index == 0) {
                prevTestConfig = (TestConfig)this.testConfigs.get(this.testConfigs.size() - 1);
                nextTestConfig = (TestConfig)this.testConfigs.get(index + 1);
            } else if (index == this.testConfigs.size() - 1) {
                prevTestConfig = (TestConfig)this.testConfigs.get(index - 1);
                nextTestConfig = (TestConfig)this.testConfigs.get(0);
            } else {
                prevTestConfig = (TestConfig)this.testConfigs.get(index - 1);
                nextTestConfig = (TestConfig)this.testConfigs.get(index + 1);
            }
            request.setAttribute("prevTest", (Object)prevTestConfig);
            request.setAttribute("nextTest", (Object)nextTestConfig);
            request.setAttribute("testId", (Object)new Integer(testId));
            request.setAttribute("test", (Object)test);
        }
        response.setContentType("text/html");
        String displayUri = null;
        displayUri = testConfig != null ? testConfig.getDisplayURI() : "/jsp/introduction.jsp";
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(displayUri);
        dispatcher.include(request, response);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/jsp/edit.jsp");
        dispatcher.include(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/jsp/help.jsp");
        dispatcher.include(request, response);
    }

    private String getTestId(PortletRequest request) {
        String testId = request.getParameter("testId");
        String prevTestId = request.getParameter("previousTestId");
        String nextTestId = request.getParameter("nextTestId");
        if ((testId == null || testId.trim().length() == 0) && nextTestId == null && prevTestId == null && this.tests.size() > 0) {
            return null;
        }
        if (testId == null && prevTestId != null) {
            int previousTestIdInt = Integer.parseInt(prevTestId);
            testId = previousTestIdInt >= this.testConfigs.size() - 1 ? "0" : String.valueOf(previousTestIdInt + 1);
        } else if (testId == null && nextTestId != null) {
            int nextTestIdInt = Integer.parseInt(nextTestId);
            testId = nextTestIdInt <= 0 ? String.valueOf(this.testConfigs.size() - 1) : String.valueOf(nextTestIdInt - 1);
        }
        return testId;
    }
}

