/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.descriptors.services.castor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.descriptors.services.castor.EntityResolverImpl;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;

abstract class AbstractCastorDescriptorService {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$descriptors$services$castor$AbstractCastorDescriptorService == null ? (class$org$apache$pluto$descriptors$services$castor$AbstractCastorDescriptorService = AbstractCastorDescriptorService.class$("org.apache.pluto.descriptors.services.castor.AbstractCastorDescriptorService")) : class$org$apache$pluto$descriptors$services$castor$AbstractCastorDescriptorService));
    private static final String JAXP_PROPERTY = "org.apache.pluto.useJaxp";
    private static final String JAXP_DEFAULT = "false";
    protected static boolean USING_JAXP = System.getProperty("org.apache.pluto.useJaxp", "false").equalsIgnoreCase("true");
    static /* synthetic */ Class class$org$apache$pluto$descriptors$services$castor$AbstractCastorDescriptorService;

    AbstractCastorDescriptorService() {
    }

    protected Object readInternal(InputStream is) throws IOException {
        Object object = null;
        try {
            if (USING_JAXP) {
                LocalConfiguration castorConfig = LocalConfiguration.getInstance();
                castorConfig.getProperties().setProperty("org.exolab.castor.parser", "");
                castorConfig.getProperties().setProperty("org.exolab.castor.xml.serializer.factory", "org.exolab.castor.xml.XercesJDK5XMLSerializerFactory");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pluto descriptor service implementation using JAXP: [" + USING_JAXP + "]"));
            }
            Mapping mapping = this.getCastorMapping();
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            unmarshaller.setEntityResolver((EntityResolver)new EntityResolverImpl());
            unmarshaller.setIgnoreExtraElements(this.getIgnoreExtraElements());
            if (is != null) {
                InputStreamReader in = new InputStreamReader(is);
                object = unmarshaller.unmarshal((Reader)in);
            }
        }
        catch (Exception me) {
            me.printStackTrace();
            throw new IOException(me.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return object;
    }

    protected void writeInternal(Object object, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMapping(this.getCastorMapping());
            LocalConfiguration castorConfig = LocalConfiguration.getInstance();
            if (USING_JAXP) {
                castorConfig.getProperties().setProperty("org.exolab.castor.parser", "");
                castorConfig.getProperties().setProperty("org.exolab.castor.xml.serializer.factory", "org.exolab.castor.xml.XercesJDK5XMLSerializerFactory");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pluto descriptor service implementation using JAXP: [" + USING_JAXP + "]"));
            }
            castorConfig.getProperties().setProperty("org.exolab.castor.indent", "true");
            this.setCastorMarshallerOptions(marshaller, object);
            marshaller.marshal(object);
        }
        catch (IOException io) {
            throw io;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    protected boolean getIgnoreExtraElements() {
        return false;
    }

    protected abstract Mapping getCastorMapping() throws IOException, MappingException;

    protected abstract String getPublicId();

    protected abstract String getDTDUri();

    protected void setCastorMarshallerOptions(Marshaller marshaller, Object beingMarshalled) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

