/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T checkNotNull(T o, String name) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException(name + " should not be null");
        }
        return o;
    }

    public static void checkArgument(boolean isValid, String message) throws IllegalArgumentException {
        if (!isValid) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean isValid, String message, Object ... args) throws IllegalArgumentException {
        if (!isValid) {
            throw new IllegalArgumentException(String.format(String.valueOf(message), Preconditions.strings(args)));
        }
    }

    public static void checkState(boolean isValid, String message) throws IllegalStateException {
        if (!isValid) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkState(boolean isValid, String message, Object ... args) throws IllegalStateException {
        if (!isValid) {
            throw new IllegalStateException(String.format(String.valueOf(message), Preconditions.strings(args)));
        }
    }

    private static String[] strings(Object[] objects) {
        String[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            strings[i] = String.valueOf(objects[i]);
        }
        return strings;
    }
}

