/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Inject;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansCreationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.InjectableConstructor;
import org.apache.webbeans.inject.InjectableField;
import org.apache.webbeans.inject.InjectableMethod;
import org.apache.webbeans.intercept.DecoratorHandler;
import org.apache.webbeans.intercept.DefaultInterceptorHandler;
import org.apache.webbeans.intercept.InterceptorInvocationContext;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.intercept.LifecycleInterceptorInvocationContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.InterceptorHandler;
import org.apache.webbeans.proxy.OwbInterceptorProxy;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.CDI11s;
import org.apache.webbeans.util.ExceptionUtil;

public class InjectionTargetImpl<T>
extends AbstractProducer<T>
implements InjectionTarget<T> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected volatile AnnotatedConstructor<T> constructor;
    private List<AnnotatedMethod<?>> postConstructMethods;
    private List<Interceptor<?>> postConstructInterceptors;
    private List<AnnotatedMethod<?>> preDestroyMethods;
    private List<Interceptor<?>> preDestroyInterceptors;
    private List<Interceptor<?>> aroundConstructInterceptors;
    private InterceptorResolutionService.BeanInterceptorInfo interceptorInfo = null;
    private String beanPassivationId = null;
    private Class<? extends T> proxyClass;
    private Map<Method, List<Interceptor<?>>> methodInterceptors = null;
    private InjectionTarget<T> delegate = null;
    private final boolean noProxy;

    public InjectionTargetImpl(AnnotatedType<T> annotatedType, Set<InjectionPoint> points, WebBeansContext webBeansContext, List<AnnotatedMethod<?>> postConstructMethods, List<AnnotatedMethod<?>> preDestroyMethods) {
        super(points);
        Asserts.assertNotNull(annotatedType);
        Asserts.assertNotNull(webBeansContext);
        this.annotatedType = annotatedType;
        this.webBeansContext = webBeansContext;
        this.postConstructMethods = postConstructMethods;
        this.preDestroyMethods = preDestroyMethods;
        this.noProxy = false;
    }

    public InjectionTargetImpl(InjectionTargetImpl<T> delegate) {
        super(delegate.getInjectionPoints());
        this.noProxy = true;
        this.annotatedType = delegate.annotatedType;
        this.webBeansContext = delegate.webBeansContext;
        this.postConstructMethods = delegate.postConstructMethods;
        this.preDestroyMethods = delegate.preDestroyMethods;
    }

    public InterceptorResolutionService.BeanInterceptorInfo getInterceptorInfo() {
        return this.interceptorInfo;
    }

    public void setInterceptorInfo(InterceptorResolutionService.BeanInterceptorInfo interceptorInfo, Class<? extends T> proxyClass, Map<Method, List<Interceptor<?>>> methodInterceptors, List<Interceptor<?>> postConstructInterceptors, List<Interceptor<?>> preDestroyInterceptors, List<Interceptor<?>> aroundConstruct, String beanPassivationId) {
        this.interceptorInfo = interceptorInfo;
        this.proxyClass = proxyClass;
        this.methodInterceptors = methodInterceptors;
        this.postConstructInterceptors = postConstructInterceptors;
        this.preDestroyInterceptors = preDestroyInterceptors;
        this.aroundConstructInterceptors = aroundConstruct;
        this.beanPassivationId = beanPassivationId;
    }

    protected T unwrapProxyInstance(T probableProxyInstance) {
        if (probableProxyInstance instanceof OwbInterceptorProxy) {
            this.webBeansContext.getInterceptorDecoratorProxyFactory();
            return InterceptorDecoratorProxyFactory.unwrapInstance(probableProxyInstance);
        }
        return probableProxyInstance;
    }

    public T produce(CreationalContext<T> creationalContext) {
        Object instance;
        boolean hasAroundConstruct;
        final CreationalContextImpl creationalContextImpl = (CreationalContextImpl)creationalContext;
        if (this.noProxy) {
            return this.newInstance(creationalContextImpl);
        }
        HashMap<Interceptor, Object> interceptorInstances = new HashMap<Interceptor, Object>();
        Contextual oldContextual = creationalContextImpl.getContextual();
        boolean bl = hasAroundConstruct = this.aroundConstructInterceptors != null && !this.aroundConstructInterceptors.isEmpty();
        if (this.proxyClass != null || hasAroundConstruct) {
            for (Interceptor interceptor : this.interceptorInfo.getEjbInterceptors()) {
                creationalContextImpl.putContextual(interceptor);
                interceptorInstances.put(interceptor, interceptor.create(creationalContext));
            }
            for (Interceptor interceptor : this.interceptorInfo.getCdiInterceptors()) {
                creationalContextImpl.putContextual(interceptor);
                interceptorInstances.put(interceptor, interceptor.create(creationalContext));
            }
        }
        if (hasAroundConstruct) {
            try {
                Constructor constructor = this.getConstructor().getJavaMember();
                final InjectableConstructor injectableConstructor = new InjectableConstructor(constructor, this, creationalContextImpl);
                new InterceptorInvocationContext<T>(null, CDI11s.AROUND_CONSTRUCT, this.aroundConstructInterceptors, interceptorInstances, constructor, injectableConstructor.createParameters()){

                    @Override
                    protected Object realProceed() throws Exception {
                        if (InjectionTargetImpl.this.delegate != null) {
                            return InjectionTargetImpl.this.delegate.produce((CreationalContext)creationalContextImpl);
                        }
                        return injectableConstructor.doInjection();
                    }
                }.proceed();
                instance = injectableConstructor.getInstance();
            }
            catch (Exception exception) {
                throw ExceptionUtil.throwAsRuntimeException(exception);
            }
        } else {
            instance = this.delegate != null ? this.delegate.produce((CreationalContext)creationalContextImpl) : this.newInstance(creationalContextImpl);
        }
        if (this.proxyClass != null) {
            InterceptorDecoratorProxyFactory interceptorDecoratorProxyFactory = this.webBeansContext.getInterceptorDecoratorProxyFactory();
            if (this.interceptorInfo.getSelfInterceptorBean() != null) {
                interceptorInstances.put(this.interceptorInfo.getSelfInterceptorBean(), instance);
            }
            Object delegate = instance;
            if (this.interceptorInfo.getDecorators() != null && !this.isDelegateInjection(creationalContext)) {
                List<Decorator<?>> decorators = this.interceptorInfo.getDecorators();
                HashMap instances = new HashMap();
                for (int i = decorators.size(); i > 0; --i) {
                    Decorator<?> decorator = decorators.get(i - 1);
                    creationalContextImpl.putContextual(decorator);
                    creationalContextImpl.putDelegate(delegate);
                    Object decoratorInstance = decorator.create(creationalContext);
                    instances.put(decorator, decoratorInstance);
                    delegate = interceptorDecoratorProxyFactory.createProxyInstance(this.proxyClass, instance, new DecoratorHandler(this.interceptorInfo, instances, i - 1, instance, this.beanPassivationId));
                }
            }
            DefaultInterceptorHandler<T> interceptorHandler = new DefaultInterceptorHandler<T>(instance, delegate, this.methodInterceptors, interceptorInstances, this.beanPassivationId);
            T proxyInstance = interceptorDecoratorProxyFactory.createProxyInstance(this.proxyClass, instance, interceptorHandler);
            instance = proxyInstance;
            creationalContextImpl.putContextual(oldContextual);
        }
        return instance;
    }

    protected boolean isDelegateInjection(CreationalContext<?> cc) {
        if (CreationalContextImpl.class.isInstance(cc)) {
            InjectionPoint ip = ((CreationalContextImpl)CreationalContextImpl.class.cast(cc)).getInjectionPoint();
            if (ip == null) {
                return false;
            }
            Member member = ip.getMember();
            if (member != null && Field.class.isInstance(member) && ((Field)Field.class.cast(member)).getAnnotation(Delegate.class) != null) {
                return true;
            }
        }
        return false;
    }

    protected T newInstance(CreationalContextImpl<T> creationalContext) {
        return new InjectableConstructor<T>(this.getConstructor().getJavaMember(), this, creationalContext).doInjection();
    }

    @Override
    public void dispose(T instance) {
        if (this.delegate != null) {
            this.delegate.dispose(instance);
        }
    }

    public void inject(T instance, CreationalContext<T> context) {
        if (this.delegate == null) {
            this.inject(instance.getClass(), this.unwrapProxyInstance(instance), (CreationalContextImpl)context);
        } else {
            this.delegate.inject(instance, context);
        }
    }

    private void inject(Class<?> type, T instance, CreationalContextImpl<T> context) {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        this.inject(type.getSuperclass(), instance, context);
        this.injectFields(type, instance, context);
        this.injectMethods(type, instance, context);
        this.injectInitializerMethods(type, instance, context);
        this.injectResources(instance);
    }

    private void injectFields(Class<?> type, T instance, CreationalContextImpl<T> context) {
        for (InjectionPoint injectionPoint : this.getInjectionPoints()) {
            if (!injectionPoint.getMember().getDeclaringClass().equals(type) || !(injectionPoint.getMember() instanceof Field)) continue;
            new InjectableField<T>((Field)injectionPoint.getMember(), instance, this, context).doInjection();
        }
    }

    private void injectMethods(Class<?> type, T instance, CreationalContextImpl<T> context) {
        HashSet<Member> injectedMethods = new HashSet<Member>();
        for (InjectionPoint injectionPoint : this.getInjectionPoints()) {
            if (!injectionPoint.getMember().getDeclaringClass().equals(type) || !(injectionPoint.getMember() instanceof Method) || injectedMethods.contains(injectionPoint.getMember()) || this.isProducerMethod(injectionPoint) || this.isDisposalMethod(injectionPoint) || this.isObserverMethod(injectionPoint)) continue;
            new InjectableMethod<T>((Method)injectionPoint.getMember(), instance, this, context).doInjection();
            injectedMethods.add(injectionPoint.getMember());
        }
    }

    private void injectInitializerMethods(Class<?> declaringType, T instance, CreationalContextImpl<T> context) {
        for (AnnotatedMethod method : this.annotatedType.getMethods()) {
            if (!method.getDeclaringType().getJavaClass().equals(declaringType) || !method.isAnnotationPresent(Inject.class) || !method.getParameters().isEmpty()) continue;
            new InjectableMethod<T>(method.getJavaMember(), instance, this, context).doInjection();
        }
    }

    private void injectResources(T instance) {
        try {
            ResourceInjectionService service = null;
            try {
                service = this.webBeansContext.getService(ResourceInjectionService.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (service != null) {
                service.injectJavaEEResources(instance);
            }
        }
        catch (Exception e) {
            throw new WebBeansException(MessageFormat.format(WebBeansLoggerFacade.getTokenString("ERROR_0023"), instance), e);
        }
    }

    public void postConstruct(T instance) {
        if (this.delegate != null) {
            this.delegate.postConstruct(instance);
            return;
        }
        Map<Interceptor<?>, ?> interceptorInstances = null;
        T internalInstance = instance;
        if (this.interceptorInfo != null && instance instanceof OwbInterceptorProxy) {
            InterceptorDecoratorProxyFactory pf = this.webBeansContext.getInterceptorDecoratorProxyFactory();
            InterceptorHandler ih = pf.getInterceptorHandler((OwbInterceptorProxy)instance);
            if (ih instanceof DefaultInterceptorHandler) {
                DefaultInterceptorHandler dih = (DefaultInterceptorHandler)ih;
                interceptorInstances = dih.getInstances();
                internalInstance = dih.getTarget();
            }
        } else if (this.postConstructMethods == null || this.postConstructMethods.size() == 0) {
            return;
        }
        LifecycleInterceptorInvocationContext<T> ic = new LifecycleInterceptorInvocationContext<T>(internalInstance, InterceptionType.POST_CONSTRUCT, this.postConstructInterceptors, interceptorInstances, this.postConstructMethods);
        try {
            ic.proceed();
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    public void preDestroy(T instance) {
        if (this.delegate != null) {
            this.delegate.preDestroy(instance);
            return;
        }
        Map<Interceptor<?>, ?> interceptorInstances = null;
        T internalInstance = instance;
        if (this.interceptorInfo != null && instance instanceof OwbInterceptorProxy) {
            InterceptorDecoratorProxyFactory pf = this.webBeansContext.getInterceptorDecoratorProxyFactory();
            InterceptorHandler ih = pf.getInterceptorHandler((OwbInterceptorProxy)instance);
            if (ih instanceof DefaultInterceptorHandler) {
                DefaultInterceptorHandler dih = (DefaultInterceptorHandler)ih;
                interceptorInstances = dih.getInstances();
                internalInstance = dih.getTarget();
            }
        } else if (this.preDestroyMethods == null || this.preDestroyMethods.size() == 0) {
            return;
        }
        LifecycleInterceptorInvocationContext<T> ic = new LifecycleInterceptorInvocationContext<T>(internalInstance, InterceptionType.PRE_DESTROY, this.preDestroyInterceptors, interceptorInstances, this.preDestroyMethods);
        try {
            ic.proceed();
        }
        catch (Exception e) {
            ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    protected AnnotatedConstructor<T> getConstructor() {
        if (this.constructor == null) {
            this.constructor = this.createConstructor();
        }
        return this.constructor;
    }

    protected AnnotatedConstructor<T> createConstructor() {
        AnnotatedConstructor constructor = null;
        for (InjectionPoint injectionPoint : this.getInjectionPoints()) {
            if (!(injectionPoint.getMember() instanceof Constructor) || constructor != null) continue;
            constructor = (AnnotatedConstructor)((AnnotatedParameter)injectionPoint.getAnnotated()).getDeclaringCallable();
            return constructor;
        }
        Constructor<T> defaultConstructor = this.getDefaultConstructor();
        if (defaultConstructor == null) {
            throw new WebBeansCreationException("No default constructor for " + this.annotatedType.getJavaClass().getName());
        }
        return new AnnotatedConstructorImpl<T>(this.webBeansContext, defaultConstructor, this.annotatedType);
    }

    private Constructor<T> getDefaultConstructor() {
        return this.webBeansContext.getWebBeansUtil().getNoArgConstructor(this.annotatedType.getJavaClass());
    }

    private boolean isProducerMethod(InjectionPoint injectionPoint) {
        return ((AnnotatedElement)((Object)injectionPoint.getMember())).isAnnotationPresent(Produces.class);
    }

    private boolean isObserverMethod(InjectionPoint injectionPoint) {
        if (!(injectionPoint.getMember() instanceof Method)) {
            return false;
        }
        Method method = (Method)injectionPoint.getMember();
        Annotation[][] arr$ = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = arr$[i$]) {
                if (!annotation.annotationType().equals(Observes.class)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDisposalMethod(InjectionPoint injectionPoint) {
        if (!(injectionPoint.getMember() instanceof Method)) {
            return false;
        }
        Method method = (Method)injectionPoint.getMember();
        Annotation[][] arr$ = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = arr$[i$]) {
                if (!annotation.annotationType().equals(Disposes.class)) continue;
                return true;
            }
        }
        return false;
    }

    public void setDelegate(InjectionTarget<T> delegate) {
        this.delegate = delegate;
    }

    public InjectionTarget<T> simpleInstance() {
        return new InjectionTargetImpl<T>(this);
    }
}

