/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InterceptionType;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InvocationContextImpl;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.OpenWebBeansEjbLCAPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterceptorUtil {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(InterceptorUtil.class);
    private final OpenWebBeansEjbLCAPlugin ejbPlugin;
    private final Class<? extends Annotation> prePassivateClass;
    private final Class<? extends Annotation> postActivateClass;
    private final int MODIFIER_STATIC_FINAL_PRIVATE = 26;
    private final WebBeansContext webBeansContext;

    public InterceptorUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.ejbPlugin = webBeansContext.getPluginLoader().getEjbLCAPlugin();
        if (this.ejbPlugin != null) {
            this.prePassivateClass = this.ejbPlugin.getPrePassivateClass();
            this.postActivateClass = this.ejbPlugin.getPostActivateClass();
        } else {
            this.prePassivateClass = null;
            this.postActivateClass = null;
        }
    }

    public boolean isWebBeansBusinessMethod(Method method) {
        Annotation[] anns;
        int modifiers = method.getModifiers();
        if ((modifiers & 0x1A) != 0) {
            return false;
        }
        for (Annotation ann : anns = method.getDeclaredAnnotations()) {
            Class<? extends Annotation> annCls = ann.annotationType();
            if (!annCls.equals(Inject.class) && !annCls.equals(PreDestroy.class) && !annCls.equals(PostConstruct.class) && !annCls.equals(AroundInvoke.class) && !annCls.equals(AroundTimeout.class) && (this.ejbPlugin == null || !annCls.equals(this.prePassivateClass) && !annCls.equals(this.postActivateClass))) continue;
            return false;
        }
        return true;
    }

    public Class<? extends Annotation> getInterceptorAnnotationClazz(InterceptionType type) {
        if (type.equals((Object)InterceptionType.AROUND_INVOKE)) {
            return AroundInvoke.class;
        }
        if (type.equals((Object)InterceptionType.POST_ACTIVATE)) {
            return this.postActivateClass;
        }
        if (type.equals((Object)InterceptionType.POST_CONSTRUCT)) {
            return PostConstruct.class;
        }
        if (type.equals((Object)InterceptionType.PRE_DESTROY)) {
            return PreDestroy.class;
        }
        if (type.equals((Object)InterceptionType.PRE_PASSIVATE)) {
            return this.prePassivateClass;
        }
        if (type.equals((Object)InterceptionType.AROUND_TIMEOUT)) {
            return AroundTimeout.class;
        }
        throw new WebBeansException("Undefined interceotion type");
    }

    public <T> boolean isBusinessMethodInterceptor(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod method = methodA;
            if (!method.isAnnotationPresent(AroundInvoke.class) || methodA.getParameters().isEmpty()) continue;
            List parameters = method.getParameters();
            ArrayList clazzParameters = new ArrayList();
            for (AnnotatedParameter parameter : parameters) {
                clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
            }
            Class[] params = clazzParameters.toArray(new Class[clazzParameters.size()]);
            if (params.length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method.getJavaMember()).equals(Object.class) || ClassUtil.isMethodHasCheckedException(method.getJavaMember()) || Modifier.isStatic(method.getJavaMember().getModifiers()) || ClassUtil.isFinal(method.getJavaMember().getModifiers())) continue;
            return true;
        }
        return false;
    }

    public boolean isBusinessMethodInterceptor(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(clazz)) {
            Class<?>[] params;
            if (!AnnotationUtil.hasMethodAnnotation(method, AroundInvoke.class) || !ClassUtil.isMethodHasParameter(method) || (params = ClassUtil.getMethodParameterTypes(method)).length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method).equals(Object.class) || !ClassUtil.isMethodHasException(method) || Modifier.isStatic(method.getModifiers()) || ClassUtil.isFinal(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public boolean isLifecycleMethodInterceptor(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(clazz)) {
            Class<?>[] params;
            if (!AnnotationUtil.hasMethodAnnotation(method, PostConstruct.class) && !AnnotationUtil.hasMethodAnnotation(method, PreDestroy.class) && !AnnotationUtil.hasMethodAnnotation(method, this.postActivateClass) && !AnnotationUtil.hasMethodAnnotation(method, this.prePassivateClass) || !ClassUtil.isMethodHasParameter(method) || (params = ClassUtil.getMethodParameterTypes(method)).length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method).equals(Void.TYPE) || ClassUtil.isMethodHasCheckedException(method) || Modifier.isStatic(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public <T> boolean isLifecycleMethodInterceptor(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod method = methodA;
            if (!method.isAnnotationPresent(PostConstruct.class) && !method.isAnnotationPresent(PreDestroy.class) && !method.isAnnotationPresent(this.postActivateClass) && !method.isAnnotationPresent(this.prePassivateClass) || methodA.getParameters().isEmpty()) continue;
            List parameters = method.getParameters();
            ArrayList clazzParameters = new ArrayList();
            for (AnnotatedParameter parameter : parameters) {
                clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
            }
            Class[] params = clazzParameters.toArray(new Class[clazzParameters.size()]);
            if (params.length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method.getJavaMember()).equals(Void.TYPE) || ClassUtil.isMethodHasCheckedException(method.getJavaMember()) || Modifier.isStatic(method.getJavaMember().getModifiers())) continue;
            return true;
        }
        return false;
    }

    public <T> void checkAnnotatedTypeInterceptorConditions(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            if (!methodA.isAnnotationPresent(Produces.class)) continue;
            throw new WebBeansConfigurationException("Interceptor class : " + annotatedType.getJavaClass().getName() + " can not have producer methods but it has one with name : " + methodA.getJavaMember().getName());
        }
        Set annSet = annotatedType.getAnnotations();
        Annotation[] anns = annSet.toArray(new Annotation[annSet.size()]);
        if (!this.webBeansContext.getAnnotationManager().hasInterceptorBindingMetaAnnotation(anns)) {
            throw new WebBeansConfigurationException("Interceptor class : " + annotatedType.getJavaClass().getName() + " must have at least one @InterceptorBinding annotation");
        }
        this.checkLifecycleConditions(annotatedType, anns, "Lifecycle interceptor : " + annotatedType.getJavaClass().getName() + " interceptor binding type must be defined as @Target{TYPE}");
    }

    public void checkInterceptorConditions(AnnotatedType annotatedType) {
        Asserts.assertNotNull(annotatedType);
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod method : methods) {
            List parms = method.getParameters();
            for (AnnotatedParameter parameter : parms) {
                if (!parameter.isAnnotationPresent(Produces.class)) continue;
                throw new WebBeansConfigurationException("Interceptor class : " + annotatedType.getJavaClass() + " can not have producer methods but it has one with name : " + method.getJavaMember().getName());
            }
        }
        Annotation[] anns = annotatedType.getAnnotations().toArray(new Annotation[annotatedType.getAnnotations().size()]);
        if (!this.webBeansContext.getAnnotationManager().hasInterceptorBindingMetaAnnotation(anns)) {
            throw new WebBeansConfigurationException("WebBeans Interceptor class : " + annotatedType.getJavaClass() + " must have at least one @InterceptorBinding annotation");
        }
        this.checkLifecycleConditions(annotatedType.getJavaClass(), anns, "Lifecycle interceptor : " + annotatedType.getJavaClass() + " interceptor binding type must be defined as @Target{TYPE}");
    }

    public <T> void checkLifecycleConditions(Class<T> clazz, Annotation[] annots, String errorMessage) {
        Asserts.nullCheckForClass(clazz);
        if (this.isLifecycleMethodInterceptor(clazz) && !this.isBusinessMethodInterceptor(clazz)) {
            Annotation[] anns;
            for (Annotation annotation : anns = this.webBeansContext.getAnnotationManager().getInterceptorBindingMetaAnnotations(annots)) {
                Target target = annotation.annotationType().getAnnotation(Target.class);
                ElementType[] elementTypes = target.value();
                if (elementTypes.length == 1 && elementTypes[0].equals((Object)ElementType.TYPE)) continue;
                throw new WebBeansConfigurationException(errorMessage);
            }
        }
    }

    public <T> void checkLifecycleConditions(AnnotatedType<T> annotatedType, Annotation[] annots, String errorMessage) {
        if (this.isLifecycleMethodInterceptor(annotatedType) && !this.isBusinessMethodInterceptor(annotatedType)) {
            Annotation[] anns;
            for (Annotation annotation : anns = this.webBeansContext.getAnnotationManager().getInterceptorBindingMetaAnnotations(annots)) {
                Target target = annotation.annotationType().getAnnotation(Target.class);
                ElementType[] elementTypes = target.value();
                if (elementTypes.length == 1 && elementTypes[0].equals((Object)ElementType.TYPE)) continue;
                throw new WebBeansConfigurationException(errorMessage);
            }
        }
    }

    public void checkSimpleWebBeansInterceptorConditions(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        Annotation[] anns = clazz.getDeclaredAnnotations();
        boolean hasClassInterceptors = false;
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        if (annotationManager.getInterceptorBindingMetaAnnotations(anns).length > 0) {
            hasClassInterceptors = true;
        } else {
            Annotation[] stereoTypes = annotationManager.getStereotypeMetaAnnotations(clazz.getDeclaredAnnotations());
            for (Annotation stero : stereoTypes) {
                if (!annotationManager.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                hasClassInterceptors = true;
                break;
            }
        }
        if (ClassUtil.isFinal(clazz.getModifiers()) && hasClassInterceptors) {
            throw new WebBeansConfigurationException("Final Simple class with name : " + clazz.getName() + " can not define any InterceptorBindings");
        }
        Method[] methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(clazz);
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || !ClassUtil.isFinal(modifiers)) continue;
            if (hasClassInterceptors) {
                throw new WebBeansConfigurationException("Simple web bean class : " + clazz.getName() + " can not define non-static, non-private final methods. " + "Because it is annotated with at least one @InterceptorBinding");
            }
            if (!annotationManager.hasInterceptorBindingMetaAnnotation(method.getDeclaredAnnotations())) continue;
            throw new WebBeansConfigurationException("Method : " + method.getName() + "in simple web bean class : " + clazz.getName() + " can not be defined as non-static, non-private and final. " + "Because it is annotated with at least one @InterceptorBinding");
        }
    }

    public List<InterceptorData> getInterceptorMethods(List<InterceptorData> stack, InterceptorType type) {
        ArrayList<InterceptorData> interceptors = new ArrayList<InterceptorData>();
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            Method m = null;
            InterceptorData data = it.next();
            if (type.equals((Object)InterceptorType.AROUND_INVOKE)) {
                m = data.getAroundInvoke();
            } else if (type.equals((Object)InterceptorType.AROUND_TIMEOUT)) {
                m = data.getAroundTimeout();
            } else if (type.equals((Object)InterceptorType.POST_ACTIVATE)) {
                m = data.getPostActivate();
            } else if (type.equals((Object)InterceptorType.POST_CONSTRUCT)) {
                m = data.getPostConstruct();
            } else if (type.equals((Object)InterceptorType.PRE_DESTROY)) {
                m = data.getPreDestroy();
            } else if (type.equals((Object)InterceptorType.PRE_PASSIVATE)) {
                m = data.getPrePassivate();
            }
            if (m == null) continue;
            interceptors.add(data);
        }
        return interceptors;
    }

    private boolean shouldRemoveInterceptorCommon(InterceptorData id, Method method) {
        boolean isMethodAnnotatedWithExcludeInterceptorClass = false;
        if (AnnotationUtil.hasMethodAnnotation(method, ExcludeClassInterceptors.class)) {
            isMethodAnnotatedWithExcludeInterceptorClass = true;
        }
        if (isMethodAnnotatedWithExcludeInterceptorClass && !id.isDefinedInMethod() && id.isDefinedInInterceptorClass()) {
            return true;
        }
        return id.isDefinedInMethod() && !id.getInterceptorBindingMethod().equals(method);
    }

    public void filterCommonInterceptorStackList(List<InterceptorData> stack, Method method) {
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            InterceptorData data = it.next();
            if (!this.shouldRemoveInterceptorCommon(data, method)) continue;
            it.remove();
        }
    }

    public Object callAroundInvokes(WebBeansContext webBeansContext, InjectionTargetBean<?> bean, Object instance, CreationalContextImpl<?> creationalContext, Method proceed, Object[] arguments, List<InterceptorData> stack, InvocationContext ejbInvocationContext, Object altKey) throws Exception {
        InvocationContextImpl impl = new InvocationContextImpl(webBeansContext, bean, instance, proceed, arguments, stack, InterceptorType.AROUND_INVOKE);
        if (ejbInvocationContext != null) {
            impl.setEJBInvocationContext(ejbInvocationContext);
        }
        if (altKey != null) {
            impl.setCcKey(altKey);
        }
        impl.setCreationalContext(creationalContext);
        return impl.proceed();
    }

    public boolean checkInInterceptorHierarchy(Class<?> interceptorClass, Class<?> candidateClass) {
        Class<?> superClassInterceptor = interceptorClass.getSuperclass();
        if (superClassInterceptor != null && !superClassInterceptor.equals(Object.class)) {
            if (superClassInterceptor.equals(candidateClass)) {
                return true;
            }
            return this.checkInInterceptorHierarchy(superClassInterceptor, candidateClass);
        }
        return false;
    }

    public void filterOverridenLifecycleInterceptor(Class<?> beanClass, List<InterceptorData> stack) {
        ArrayList overridenInterceptors = new ArrayList();
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            InterceptorData overridenInterceptor;
            InterceptorData interceptorData = it.next();
            if (!interceptorData.isLifecycleInterceptor() || null == (overridenInterceptor = this.getOverridenInterceptor(beanClass, interceptorData, stack))) continue;
            if (logger.wblWillLogDebug()) {
                logger.debug("REMOVING parent " + overridenInterceptor);
            }
            it.remove();
        }
        stack.removeAll(overridenInterceptors);
    }

    public void filterOverridenAroundInvokeInterceptor(Class<?> beanClass, List<InterceptorData> stack) {
        ArrayList<InterceptorData> overridenInterceptors = null;
        for (InterceptorData interceptorData : stack) {
            InterceptorData overridenInterceptor;
            if (interceptorData.getAroundInvoke() == null || null == (overridenInterceptor = this.getOverridenInterceptor(beanClass, interceptorData, stack))) continue;
            if (overridenInterceptors == null) {
                overridenInterceptors = new ArrayList<InterceptorData>();
            }
            overridenInterceptors.add(overridenInterceptor);
            if (!logger.wblWillLogDebug()) continue;
            logger.debug("REMOVING parent " + overridenInterceptor);
        }
        if (overridenInterceptors != null) {
            stack.removeAll(overridenInterceptors);
        }
    }

    private InterceptorData getOverridenInterceptor(Class<?> clazz, InterceptorData interceptorData, List<InterceptorData> stack) {
        Method interceptor = interceptorData.getInterceptorMethod();
        Class<?> interceptorClass = interceptor.getDeclaringClass();
        for (InterceptorData superInterceptorData : stack) {
            if (interceptorClass.equals(superInterceptorData.getInterceptorClass())) continue;
            if (this.checkInInterceptorHierarchy(interceptorClass, superInterceptorData.getInterceptorClass())) {
                Method superInterceptorMethod = superInterceptorData.getInterceptorMethod();
                Method childInterceptorMethod = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(interceptorClass, superInterceptorMethod.getName(), (Class[])superInterceptorMethod.getParameterTypes());
                if (null == childInterceptorMethod || !ClassUtil.isOverridden(childInterceptorMethod, superInterceptorMethod)) continue;
                return superInterceptorData;
            }
            return this.removeInheritedButOverridenInterceptor(clazz, interceptorData);
        }
        return null;
    }

    private InterceptorData removeInheritedButOverridenInterceptor(Class<?> clazz, InterceptorData interceptorData) {
        Method interceptor = interceptorData.getInterceptorMethod();
        Class<?> declaringClass = interceptor.getDeclaringClass();
        if (this.checkGivenClassIsInInterceptorList(clazz, declaringClass)) {
            return null;
        }
        if (!declaringClass.equals(clazz) && this.checkInInterceptorHierarchy(clazz, declaringClass)) {
            Class<?> superClass;
            Method found = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(clazz, interceptor.getName(), (Class[])interceptor.getParameterTypes());
            if (found == null && (superClass = clazz.getSuperclass()) != null && !superClass.equals(Object.class)) {
                return this.removeInheritedButOverridenInterceptor(superClass, interceptorData);
            }
            return interceptorData;
        }
        return null;
    }

    public boolean checkGivenClassIsInInterceptorList(Class<?> mainClass, Class<?> candidateClass) {
        if (AnnotationUtil.hasClassAnnotation(mainClass, Interceptors.class)) {
            Class[] intClasses;
            Interceptors incs = mainClass.getAnnotation(Interceptors.class);
            for (Class intClass : intClasses = incs.value()) {
                if (intClass.equals(candidateClass)) {
                    return true;
                }
                if (!this.checkInInterceptorHierarchy(intClass, candidateClass)) continue;
                return true;
            }
        }
        return false;
    }
}

