/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InjectionPointImpl
implements InjectionPoint,
Serializable {
    private static final long serialVersionUID = 1047233127758068484L;
    private Set<Annotation> qualifierAnnotations = new HashSet<Annotation>();
    private Bean<?> ownerBean;
    private Member injectionMember;
    private Type injectionType;
    private Annotated annotated;
    private boolean transientt;
    private boolean delegate;

    InjectionPointImpl(Bean<?> ownerBean, Type type, Member member, Annotated annotated) {
        this.ownerBean = ownerBean;
        this.injectionMember = member;
        this.injectionType = type;
        this.annotated = annotated;
    }

    void addBindingAnnotation(Annotation qualifierAnnotations) {
        this.qualifierAnnotations.add(qualifierAnnotations);
    }

    public Bean<?> getBean() {
        return this.ownerBean;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifierAnnotations;
    }

    public Member getMember() {
        return this.injectionMember;
    }

    public Type getType() {
        return this.injectionType;
    }

    public Annotated getAnnotated() {
        return this.annotated;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public boolean isTransient() {
        return this.transientt;
    }

    void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    void setTransient(boolean transientt) {
        this.transientt = transientt;
    }

    private void writeObject(ObjectOutputStream op) throws IOException {
        AnnotatedParameter ap;
        Class<?>[] parameters;
        ObjectOutputStream out = new ObjectOutputStream(op);
        out.writeObject(this.ownerBean.getBeanClass());
        Set qualifiers = this.ownerBean.getQualifiers();
        for (Annotation qualifier : qualifiers) {
            out.writeObject(Character.valueOf('-'));
            out.writeObject(qualifier);
        }
        out.writeObject(Character.valueOf('~'));
        if (this.injectionMember instanceof Field) {
            out.writeByte(0);
            out.writeUTF(this.injectionMember.getName());
        }
        if (this.injectionMember instanceof Method) {
            out.writeByte(1);
            out.writeUTF(this.injectionMember.getName());
            Method method = (Method)this.injectionMember;
            parameters = method.getParameterTypes();
            out.writeObject(parameters);
            ap = (AnnotatedParameter)this.annotated;
            out.writeByte(ap.getPosition());
        }
        if (this.injectionMember instanceof Constructor) {
            out.writeByte(2);
            Constructor constr = (Constructor)this.injectionMember;
            parameters = constr.getParameterTypes();
            out.writeObject(parameters);
            ap = (AnnotatedParameter)this.annotated;
            out.writeByte(ap.getPosition());
        }
        out.writeBoolean(this.delegate);
        out.writeBoolean(this.transientt);
        out.flush();
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        CustomObjectInputStream in = new CustomObjectInputStream(inp, WebBeansUtil.getCurrentClassLoader());
        Class beanClass = (Class)in.readObject();
        HashSet<Annotation> anns = new HashSet<Annotation>();
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        AnnotatedElementFactory annotatedElementFactory = webBeansContext.getAnnotatedElementFactory();
        while (!in.readObject().equals(Character.valueOf('~'))) {
            Annotation ann = (Annotation)in.readObject();
            anns.add(ann);
        }
        this.ownerBean = webBeansContext.getBeanManagerImpl().getBeans(beanClass, anns.toArray(new Annotation[anns.size()])).iterator().next();
        this.qualifierAnnotations = anns;
        byte c = in.readByte();
        if (c == 0) {
            String fieldName = in.readUTF();
            Field field = webBeansContext.getSecurityService().doPrivilegedGetDeclaredField(beanClass, fieldName);
            this.injectionMember = field;
            AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(beanClass);
            this.annotated = annotatedElementFactory.newAnnotatedField(field, annotatedType);
            this.injectionType = field.getGenericType();
        } else if (c == 1) {
            String methodName = in.readUTF();
            Class[] parameters = (Class[])in.readObject();
            Method method = webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(beanClass, methodName, parameters);
            this.injectionMember = method;
            AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(beanClass);
            AnnotatedMethod am = annotatedElementFactory.newAnnotatedMethod((Method)this.injectionMember, annotatedType);
            List annParameters = am.getParameters();
            this.annotated = (Annotated)annParameters.get(in.readByte());
            this.injectionType = this.annotated.getBaseType();
        } else if (c == 2) {
            Class[] parameters = (Class[])in.readObject();
            try {
                this.injectionMember = beanClass.getConstructor(parameters);
            }
            catch (NoSuchMethodException e) {
                this.injectionMember = null;
            }
            AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(beanClass);
            AnnotatedConstructor am = annotatedElementFactory.newAnnotatedConstructor((Constructor)this.injectionMember, annotatedType);
            List annParameters = am.getParameters();
            this.annotated = (Annotated)annParameters.get(in.readByte());
            this.injectionType = this.annotated.getBaseType();
        }
        this.delegate = in.readBoolean();
        this.transientt = in.readBoolean();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.injectionMember instanceof Constructor) {
            Constructor constructor = (Constructor)this.injectionMember;
            buffer.append("Constructor Injection Point, constructor name :  " + constructor.getName() + ", Bean Owner : [" + this.ownerBean.toString() + "]");
        } else if (this.injectionMember instanceof Method) {
            Method method = (Method)this.injectionMember;
            buffer.append("Method Injection Point, method name :  " + method.getName() + ", Bean Owner : [" + this.ownerBean.toString() + "]");
        } else if (this.injectionMember instanceof Field) {
            Field field = (Field)this.injectionMember;
            buffer.append("Field Injection Point, field name :  " + field.getName() + ", Bean Owner : [" + this.ownerBean.toString() + "]");
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CustomObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        public CustomObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
            return Class.forName(desc.getName(), false, this.classLoader);
        }
    }
}

