/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MascPennTagParser
extends DefaultHandler {
    private Map<Integer, int[]> tokenToQuarks = new HashMap<Integer, int[]>();
    private Map<Integer, String> tokenToTag = new HashMap<Integer, String>();
    private Map<Integer, String> tokenToBase = new HashMap<Integer, String>();
    private Stack<Integer> tokenStack = new Stack();
    private Stack<Integer> tokenStackTag = new Stack();

    public Map<Integer, String> getTags() {
        return this.tokenToTag;
    }

    public Map<Integer, String> getBases() {
        return this.tokenToBase;
    }

    public Map<Integer, int[]> getTokenToQuarks() {
        return this.tokenToQuarks;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (qName.equals("node")) {
                this.tokenStack.push(Integer.parseInt(attributes.getValue("xml:id").replaceFirst("penn-n", "")));
            }
            if (qName.equals("link")) {
                if (this.tokenStack.isEmpty()) {
                    throw new SAXException("The linking of tokens to quarks is broken.");
                }
                String[] targets = attributes.getValue("targets").replaceAll("seg-r", "").split(" ");
                int[] regions = new int[targets.length];
                for (int i = 0; i < targets.length; ++i) {
                    int region;
                    regions[i] = region = Integer.parseInt(targets[i]);
                }
                this.tokenToQuarks.put(this.tokenStack.pop(), regions);
            }
            if (qName.equals("a")) {
                this.tokenStackTag.push(Integer.parseInt(attributes.getValue("ref").replaceFirst("penn-n", "")));
            }
            if (qName.equals("f")) {
                String type = attributes.getValue("name");
                if (this.tokenStackTag.isEmpty()) {
                    throw new SAXException("The linking of tokens to their tags/bases is broken.");
                }
                if (type.equals("msd")) {
                    this.tokenToTag.put(this.tokenStackTag.peek(), attributes.getValue("value"));
                } else if (type.equals("base")) {
                    this.tokenToBase.put(this.tokenStackTag.peek(), attributes.getValue("value"));
                }
            }
        }
        catch (Exception e) {
            throw new SAXException("Could not parse the Penn-POS annotation file.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("a")) {
            this.tokenStackTag.pop();
        }
    }
}

