/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.SavepointFieldManager;
import org.apache.openjpa.kernel.StateManagerImpl;

public class OpenJPASavepoint
implements Serializable {
    private final Broker _broker;
    private final String _name;
    private final boolean _copy;
    private Map<StateManagerImpl, SavepointFieldManager> _saved;

    public OpenJPASavepoint(Broker broker, String name, boolean copy) {
        this._broker = broker;
        this._name = name;
        this._copy = copy;
    }

    public Broker getBroker() {
        return this._broker;
    }

    public String getName() {
        return this._name;
    }

    public boolean getCopyFieldState() {
        return this._copy;
    }

    protected Map<StateManagerImpl, SavepointFieldManager> getStates() {
        return this._saved;
    }

    public void save(Collection<StateManagerImpl> states) {
        if (this._saved != null) {
            throw new IllegalStateException();
        }
        this._saved = new HashMap<StateManagerImpl, SavepointFieldManager>((int)((double)states.size() * 1.33 + 1.0));
        for (StateManagerImpl sm : states) {
            this._saved.put(sm, new SavepointFieldManager(sm, this._copy));
        }
    }

    public void release(boolean user) {
        this._saved = null;
    }

    public Collection<SavepointFieldManager> rollback(Collection<OpenJPASavepoint> previous) {
        Map<StateManagerImpl, SavepointFieldManager> saved;
        if (previous.isEmpty()) {
            saved = this._saved;
        } else {
            saved = new HashMap<StateManagerImpl, SavepointFieldManager>();
            for (OpenJPASavepoint savepoint : previous) {
                saved.putAll(savepoint.getStates());
            }
            saved.putAll(this._saved);
        }
        this._saved = null;
        return saved.values();
    }
}

