/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.openejb.maven.plugin.AbstractTomEEMojo;
import org.apache.openejb.maven.plugin.util.Zips;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildTomEEMojo
extends AbstractTomEEMojo {
    @Parameter(property="tomee-plugin.zip", defaultValue="true")
    protected boolean zip;
    @Parameter(property="tomee-plugin.attach", defaultValue="true")
    protected boolean attach;
    @Parameter(property="tomee-plugin.zip-file", defaultValue="${project.build.directory}/${project.build.finalName}.zip")
    protected File zipFile;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="tomee-plugin.classifier")
    protected String classifier = null;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.zip) {
            this.getLog().info((CharSequence)"Zipping Custom TomEE Distribution");
            try {
                Zips.zip(this.catalinaBase, this.zipFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            if (this.attach) {
                this.getLog().info((CharSequence)"Attaching Custom TomEE Distribution");
                if (this.classifier != null) {
                    this.projectHelper.attachArtifact(this.project, "zip", this.classifier, this.zipFile);
                } else {
                    this.projectHelper.attachArtifact(this.project, "zip", this.zipFile);
                }
            }
        }
    }

    @Override
    protected void run() {
    }

    @Override
    public String getCmd() {
        return null;
    }

    @Override
    protected boolean getWaitTomEE() {
        return false;
    }
}

