/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng.conf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.surefire.testng.conf.AbstractDirectConfigurator;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.TestNG;

public class TestNGMapConfigurator
implements Configurator {
    public void configure(TestNG testng, Map options) throws TestSetFailedException {
        HashMap convertedOptions = new HashMap();
        Iterator it = options.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if ("listener".equals(key)) {
                val = AbstractDirectConfigurator.loadListenerClasses((String)val);
            }
            if ("objectfactory".equals(key)) {
                val = AbstractDirectConfigurator.loadClass((String)val);
            }
            if ("reporter".equals(key)) {
                val = this.convertReporterConfig(val);
                key = "reporterslist";
            }
            if ("junit".equals(key)) {
                val = this.convert(val, class$java$lang$Boolean == null ? TestNGMapConfigurator.class$("java.lang.Boolean") : class$java$lang$Boolean);
            } else if ("skipfailedinvocationcounts".equals(key)) {
                val = this.convert(val, class$java$lang$Boolean == null ? TestNGMapConfigurator.class$("java.lang.Boolean") : class$java$lang$Boolean);
            } else if ("threadcount".equals(key)) {
                val = this.convert(val, class$java$lang$String == null ? TestNGMapConfigurator.class$("java.lang.String") : class$java$lang$String);
            }
            if (key.startsWith("-")) {
                convertedOptions.put(key, val);
                continue;
            }
            convertedOptions.put("-" + key, val);
        }
        testng.configure(convertedOptions);
    }

    private Object convertReporterConfig(Object val) {
        String reporterConfigClassName = "org.testng.ReporterConfig";
        try {
            Class<?> reporterConfig = Class.forName("org.testng.ReporterConfig");
            Method deserialize = reporterConfig.getMethod("deserialize", String.class);
            Object rc = deserialize.invoke(null, val);
            ArrayList<Object> reportersList = new ArrayList<Object>();
            reportersList.add(rc);
            return reportersList;
        }
        catch (Exception e) {
            return val;
        }
    }

    protected Object convert(Object val, Class type) {
        if (val == null) {
            return null;
        }
        if (type.isAssignableFrom(val.getClass())) {
            return val;
        }
        if ((Boolean.class.equals(type) || Boolean.TYPE.equals(type)) && String.class.equals(val.getClass())) {
            return Boolean.valueOf((String)val);
        }
        if (String.class.equals(type)) {
            return val.toString();
        }
        return val;
    }
}

