/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.TestNgTestSuite;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testng.conf.TestNG4751Configurator;
import org.apache.maven.surefire.testng.conf.TestNG52Configurator;
import org.apache.maven.surefire.testng.conf.TestNGMapConfigurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.testng.TestNG;

public class TestNGExecutor {
    private TestNGExecutor() {
    }

    public static void run(Class[] testClasses, String testSourceDirectory, Map options, ArtifactVersion version, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory, String methodNamePattern) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        if (!StringUtils.isBlank((String)methodNamePattern)) {
            TestNGExecutor.applyMethodNameFiltering(testng, methodNamePattern);
        }
        Configurator configurator = TestNGExecutor.getConfigurator(version);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, reportManager, suite, reportsDirectory);
        testng.setTestClasses(testClasses);
        testng.run();
    }

    private static void applyMethodNameFiltering(TestNG testng, String methodNamePattern) throws TestSetFailedException {
        String clazzName = "org.apache.maven.surefire.testng.utils.MethodSelector";
        testng.addMethodSelector(clazzName, 10000);
        try {
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod("setMethodName", String.class);
            method.invoke(null, methodNamePattern);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public static void run(List suiteFiles, String testSourceDirectory, Map options, ArtifactVersion version, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        TestNG testng = new TestNG(true);
        Configurator configurator = TestNGExecutor.getConfigurator(version);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, reportManager, suite, reportsDirectory);
        testng.setTestSuites(suiteFiles);
        testng.run();
    }

    private static Configurator getConfigurator(ArtifactVersion version) throws TestSetFailedException {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,5.1]");
            if (range.containsVersion(version)) {
                return new TestNG4751Configurator();
            }
            range = VersionRange.createFromVersionSpec((String)"[5.2]");
            if (range.containsVersion(version)) {
                return new TestNG52Configurator();
            }
            range = VersionRange.createFromVersionSpec((String)"[5.3,)");
            if (range.containsVersion(version)) {
                return new TestNGMapConfigurator();
            }
            throw new TestSetFailedException("Unknown TestNG version " + version);
        }
        catch (InvalidVersionSpecificationException invsex) {
            throw new TestSetFailedException("Bug in plugin. Please report it with the attached stacktrace", (Throwable)invsex);
        }
    }

    private static void postConfigure(TestNG testNG, String sourcePath, RunListener reportManager, TestNgTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        testNG.setVerbose(0);
        TestNGReporter reporter = TestNGExecutor.createTestNGReporter(reportManager, suite);
        testNG.addListener((Object)reporter);
        if (sourcePath != null) {
            testNG.setSourcePath(sourcePath);
        }
        testNG.setOutputDirectory(reportsDirectory.getAbsolutePath());
    }

    private static TestNGReporter createTestNGReporter(RunListener reportManager, TestNgTestSuite suite) {
        try {
            Class.forName("org.testng.internal.IResultListener");
            Class<?> c = Class.forName("org.apache.maven.surefire.testng.ConfigurationAwareTestNGReporter");
            try {
                Constructor<?> ctor = c.getConstructor(RunListener.class, TestNgTestSuite.class);
                return (TestNGReporter)ctor.newInstance(reportManager, suite);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Bug in ConfigurationAwareTestNGReporter", (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            return new TestNGReporter(reportManager);
        }
    }
}

