/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.surefire.junitcore.pc.InvokerStrategy;
import org.apache.maven.surefire.junitcore.pc.NonSharedThreadPoolStrategy;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.junitcore.pc.SharedThreadPoolStrategy;
import org.apache.maven.surefire.report.ConsoleLogger;

public class SchedulingStrategies {
    public static SchedulingStrategy createInvokerStrategy(ConsoleLogger logger) {
        return new InvokerStrategy(logger);
    }

    public static SchedulingStrategy createParallelStrategy(ConsoleLogger logger, int nThreads) {
        return new NonSharedThreadPoolStrategy(logger, Executors.newFixedThreadPool(nThreads));
    }

    public static SchedulingStrategy createParallelStrategyUnbounded(ConsoleLogger logger) {
        return new NonSharedThreadPoolStrategy(logger, Executors.newCachedThreadPool());
    }

    public static SchedulingStrategy createParallelSharedStrategy(ConsoleLogger logger, ExecutorService threadPool) {
        if (threadPool == null) {
            throw new NullPointerException("null threadPool in #createParallelSharedStrategy");
        }
        return new SharedThreadPoolStrategy(logger, threadPool);
    }
}

