/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.maven.surefire.junitcore.pc.Balancer;
import org.apache.maven.surefire.junitcore.pc.BalancerFactory;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.junit.runner.Description;
import org.junit.runners.model.RunnerScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler
implements RunnerScheduler {
    private final Balancer balancer;
    private final SchedulingStrategy strategy;
    private final Set<Controller> slaves = new CopyOnWriteArraySet<Controller>();
    private final Description description;
    private volatile boolean shutdown = false;
    private volatile boolean started = false;
    private volatile Controller masterController;

    public Scheduler(Description description, SchedulingStrategy strategy) {
        this(description, strategy, -1);
    }

    public Scheduler(Description description, SchedulingStrategy strategy, int concurrency) {
        this(description, strategy, BalancerFactory.createBalancer(concurrency));
    }

    public Scheduler(Description description, SchedulingStrategy strategy, Balancer balancer) {
        strategy.setDefaultShutdownHandler(this.newShutdownHandler());
        this.description = description;
        this.strategy = strategy;
        this.balancer = balancer;
        this.masterController = null;
    }

    public Scheduler(Description description, Scheduler masterScheduler, SchedulingStrategy strategy, Balancer balancer) {
        this(description, strategy, balancer);
        strategy.setDefaultShutdownHandler(this.newShutdownHandler());
        masterScheduler.register(this);
    }

    public Scheduler(Description description, Scheduler masterScheduler, SchedulingStrategy strategy, int concurrency) {
        this(description, strategy, concurrency);
        strategy.setDefaultShutdownHandler(this.newShutdownHandler());
        masterScheduler.register(this);
    }

    public Scheduler(Description description, Scheduler masterScheduler, SchedulingStrategy strategy) {
        this(description, masterScheduler, strategy, 0);
    }

    private void setController(Controller masterController) {
        if (masterController == null) {
            throw new NullPointerException("null ExecutionController");
        }
        this.masterController = masterController;
    }

    private boolean register(Scheduler slave) {
        boolean canRegister;
        boolean bl = canRegister = slave != null && slave != this;
        if (canRegister) {
            Controller controller = new Controller(slave);
            boolean bl2 = canRegister = !this.slaves.contains(controller);
            if (canRegister) {
                this.slaves.add(controller);
                slave.setController(controller);
            }
        }
        return canRegister;
    }

    private boolean canSchedule() {
        return !this.shutdown && (this.masterController == null || this.masterController.canSchedule());
    }

    protected void logQuietly(Throwable t) {
        t.printStackTrace(System.err);
    }

    protected void logQuietly(String msg) {
        System.err.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Description> shutdown(boolean shutdownNow) {
        this.shutdown = true;
        ArrayList<Description> activeChildren = new ArrayList<Description>();
        if (this.started && this.description != null) {
            activeChildren.add(this.description);
        }
        for (Controller slave : this.slaves) {
            try {
                activeChildren.addAll(slave.shutdown(shutdownNow));
            }
            catch (Throwable t) {
                this.logQuietly(t);
            }
        }
        try {
            this.balancer.releaseAllPermits();
        }
        finally {
            if (shutdownNow) {
                this.strategy.stopNow();
            } else {
                this.strategy.stop();
            }
        }
        return activeChildren;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    public void schedule(Runnable childStatement) {
        if (childStatement == null) {
            this.logQuietly("cannot schedule null");
        } else if (this.canSchedule() && this.strategy.canSchedule()) {
            try {
                boolean isNotInterrupted = this.balancer.acquirePermit();
                if (isNotInterrupted && !this.shutdown) {
                    Runnable task = this.wrapTask(childStatement);
                    this.strategy.schedule(task);
                    this.started = true;
                }
            }
            catch (RejectedExecutionException e) {
                this.shutdown(false);
            }
            catch (Throwable t) {
                this.balancer.releasePermit();
                this.logQuietly(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        try {
            this.strategy.finished();
        }
        catch (InterruptedException e) {
            this.logQuietly(e);
        }
        finally {
            for (Controller slave : this.slaves) {
                slave.awaitFinishedQuietly();
            }
        }
    }

    private Runnable wrapTask(final Runnable task) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Scheduler.this.beforeExecute();
                    task.run();
                }
                finally {
                    try {
                        Scheduler.this.afterExecute();
                    }
                    finally {
                        Scheduler.this.balancer.releasePermit();
                    }
                }
            }
        };
    }

    protected ShutdownHandler newShutdownHandler() {
        return new ShutdownHandler();
    }

    public class ShutdownHandler
    implements RejectedExecutionHandler {
        private volatile RejectedExecutionHandler poolHandler = null;

        protected ShutdownHandler() {
        }

        public void setRejectedExecutionHandler(RejectedExecutionHandler poolHandler) {
            this.poolHandler = poolHandler;
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            RejectedExecutionHandler poolHandler;
            if (executor.isShutdown()) {
                Scheduler.this.shutdown(false);
            }
            if ((poolHandler = this.poolHandler) != null) {
                poolHandler.rejectedExecution(r, executor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Controller {
        private final Scheduler slave;

        private Controller(Scheduler slave) {
            this.slave = slave;
        }

        boolean canSchedule() {
            return Scheduler.this.canSchedule();
        }

        void awaitFinishedQuietly() {
            try {
                this.slave.finished();
            }
            catch (Throwable t) {
                this.slave.logQuietly(t);
            }
        }

        Collection<Description> shutdown(boolean shutdownNow) {
            return this.slave.shutdown(shutdownNow);
        }

        public int hashCode() {
            return this.slave.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Controller && this.slave.equals(((Controller)o).slave);
        }
    }
}

