/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.junit.runner.Description;

public class TestSet {
    private final Description testSetDescription;
    private final AtomicInteger numberOfCompletedChildren = new AtomicInteger(0);
    private final AtomicInteger numberOfTests = new AtomicInteger(0);
    private final List<TestMethod> testMethods = Collections.synchronizedList(new ArrayList());
    private static final InheritableThreadLocal<TestSet> testSet = new InheritableThreadLocal();
    private final AtomicBoolean allScheduled = new AtomicBoolean();
    private final AtomicBoolean played = new AtomicBoolean();
    private volatile LogicalStream beforeClass;
    private volatile LogicalStream afterClass;

    public TestSet(Description testSetDescription) {
        this.testSetDescription = testSetDescription;
    }

    public void replay(RunListener target) {
        if (!this.played.compareAndSet(false, true)) {
            return;
        }
        try {
            ReportEntry report = this.createReportEntry(null);
            target.testSetStarting(report);
            if (this.beforeClass != null) {
                this.beforeClass.writeDetails((ConsoleOutputReceiver)target);
            }
            int elapsed = 0;
            for (TestMethod testMethod : this.testMethods) {
                elapsed += testMethod.getElapsed();
                testMethod.replay(target);
            }
            report = this.createReportEntry(elapsed);
            if (this.afterClass != null) {
                this.afterClass.writeDetails((ConsoleOutputReceiver)target);
            }
            target.testSetCompleted(report);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TestMethod createThreadAttachedTestMethod(ReportEntry description) {
        TestMethod testMethod = new TestMethod(description, this);
        this.addTestMethod(testMethod);
        testMethod.attachToThread();
        return testMethod;
    }

    private ReportEntry createReportEntry(Integer elapsed) {
        boolean isJunit3 = this.testSetDescription.getTestClass() == null;
        String classNameToUse = isJunit3 ? ((Description)this.testSetDescription.getChildren().get(0)).getClassName() : this.testSetDescription.getClassName();
        return new SimpleReportEntry(classNameToUse, classNameToUse, elapsed);
    }

    public void incrementTestMethodCount() {
        this.numberOfTests.incrementAndGet();
    }

    private void addTestMethod(TestMethod testMethod) {
        this.testMethods.add(testMethod);
    }

    public void incrementFinishedTests(RunListener reporterManager, boolean reportImmediately) {
        this.numberOfCompletedChildren.incrementAndGet();
        if (this.allScheduled.get() && this.isAllTestsDone() && reportImmediately) {
            this.replay(reporterManager);
        }
    }

    public void setAllScheduled(RunListener reporterManager) {
        this.allScheduled.set(true);
        if (this.isAllTestsDone()) {
            this.replay(reporterManager);
        }
    }

    private boolean isAllTestsDone() {
        return this.numberOfTests.get() == this.numberOfCompletedChildren.get();
    }

    public void attachToThread() {
        testSet.set(this);
    }

    public static TestSet getThreadTestSet() {
        return (TestSet)testSet.get();
    }

    public LogicalStream getClassLevelLogicalStream() {
        if (this.numberOfCompletedChildren.get() > 0) {
            if (this.afterClass == null) {
                this.afterClass = new LogicalStream();
            }
            return this.afterClass;
        }
        if (this.beforeClass == null) {
            this.beforeClass = new LogicalStream();
        }
        return this.beforeClass;
    }
}

