/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class NonConcurrentRunListener
extends JUnit4RunListener
implements ConsoleOutputReceiver {
    private Description currentTestSetDescription;
    private Description lastFinishedDescription;

    public NonConcurrentRunListener(RunListener reporter) throws TestSetFailedException {
        super(reporter);
    }

    public synchronized void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        ((ConsoleOutputReceiver)this.reporter).writeTestOutput(buf, off, len, stdout);
    }

    protected SimpleReportEntry createReportEntry(Description description) {
        return new SimpleReportEntry(description.getClassName(), description.getDisplayName());
    }

    protected SimpleReportEntry createReportEntryForTestSet(Description description) {
        return new SimpleReportEntry(description.getClassName(), description.getClassName());
    }

    public void testStarted(Description description) throws Exception {
        this.finishLastTestSetIfNeccessary(description);
        super.testStarted(description);
    }

    private void finishLastTestSetIfNeccessary(Description description) {
        if (this.describesNewTestSet(description)) {
            this.currentTestSetDescription = description;
            if (this.lastFinishedDescription != null) {
                this.reporter.testSetCompleted((ReportEntry)this.createReportEntryForTestSet(this.lastFinishedDescription));
                this.lastFinishedDescription = null;
            }
            this.reporter.testSetStarting((ReportEntry)this.createReportEntryForTestSet(description));
        }
    }

    private boolean describesNewTestSet(Description description) {
        if (this.currentTestSetDescription != null) {
            if (null != description.getTestClass()) {
                return !description.getTestClass().equals(this.currentTestSetDescription.getTestClass());
            }
            if (description.isSuite()) {
                return description.getChildren().equals(this.currentTestSetDescription.getChildren());
            }
            return false;
        }
        return true;
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        this.lastFinishedDescription = description;
    }

    public void testIgnored(Description description) throws Exception {
        this.finishLastTestSetIfNeccessary(description);
        super.testIgnored(description);
        this.lastFinishedDescription = description;
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        this.lastFinishedDescription = failure.getDescription();
    }

    public void testAssumptionFailure(Failure failure) {
        super.testAssumptionFailure(failure);
        this.lastFinishedDescription = failure.getDescription();
    }

    public void testRunStarted(Description description) throws Exception {
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.lastFinishedDescription != null) {
            this.reporter.testSetCompleted((ReportEntry)this.createReportEntryForTestSet(this.lastFinishedDescription));
            this.lastFinishedDescription = null;
        }
    }
}

