/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4RunListener
extends RunListener {
    private static final Pattern PARENS = Pattern.compile("^.+\\(([^\\\\(\\\\)]+)\\)$");
    protected final org.apache.maven.surefire.report.RunListener reporter;
    private final ThreadLocal<Boolean> failureFlag = new InheritableThreadLocal<Boolean>();

    public JUnit4RunListener(org.apache.maven.surefire.report.RunListener reporter) {
        this.reporter = reporter;
    }

    public void testIgnored(Description description) throws Exception {
        String reason = JUnit4Reflector.getAnnotatedIgnoreValue(description);
        this.reporter.testSkipped((ReportEntry)SimpleReportEntry.ignored((String)JUnit4RunListener.getClassName(description), (String)description.getDisplayName(), (String)reason));
    }

    public void testStarted(Description description) throws Exception {
        this.reporter.testStarting((ReportEntry)this.createReportEntry(description));
        this.failureFlag.remove();
    }

    public void testFailure(Failure failure) throws Exception {
        String testHeader = failure.getTestHeader();
        if (JUnit4RunListener.isInsaneJunitNullString(testHeader)) {
            testHeader = "Failure when constructing test";
        }
        SimpleReportEntry report = SimpleReportEntry.withException((String)JUnit4RunListener.getClassName(failure.getDescription()), (String)testHeader, (StackTraceWriter)this.createStackTraceWriter(failure));
        if (failure.getException() instanceof AssertionError) {
            this.reporter.testFailed((ReportEntry)report);
        } else {
            this.reporter.testError((ReportEntry)report);
        }
        this.failureFlag.set(true);
    }

    public void testAssumptionFailure(Failure failure) {
        this.reporter.testAssumptionFailure((ReportEntry)this.createReportEntry(failure.getDescription()));
        this.failureFlag.set(true);
    }

    public void testFinished(Description description) throws Exception {
        Boolean failure = this.failureFlag.get();
        if (failure == null) {
            this.reporter.testSucceeded((ReportEntry)this.createReportEntry(description));
        }
    }

    public void testExecutionSkippedByUser() {
        this.reporter.testExecutionSkippedByUser();
    }

    private static String getClassName(Description description) {
        String name = JUnit4RunListener.extractClassName(description);
        if (name == null || JUnit4RunListener.isInsaneJunitNullString(name)) {
            Description subDescription = (Description)description.getChildren().get(0);
            if (subDescription != null) {
                name = JUnit4RunListener.extractClassName(subDescription);
            }
            if (name == null) {
                name = "Test Instantiation Error";
            }
        }
        return name;
    }

    protected StackTraceWriter createStackTraceWriter(Failure failure) {
        return new JUnit4StackTraceWriter(failure);
    }

    protected SimpleReportEntry createReportEntry(Description description) {
        return new SimpleReportEntry(JUnit4RunListener.getClassName(description), description.getDisplayName());
    }

    public static String extractClassName(Description description) {
        String displayName = description.getDisplayName();
        Matcher m = PARENS.matcher(displayName);
        return m.find() ? m.group(1) : displayName;
    }

    public static String extractMethodName(Description description) {
        String displayName = description.getDisplayName();
        int i = displayName.indexOf("(");
        return i >= 0 ? displayName.substring(0, i) : displayName;
    }

    public static void rethrowAnyTestMechanismFailures(Result run) throws TestSetFailedException {
        if (run.getFailureCount() > 0) {
            for (Failure failure : run.getFailures()) {
                Description description = failure.getDescription();
                if (!JUnit4ProviderUtil.isFailureInsideJUnitItself(description)) continue;
                Throwable exception = failure.getException();
                throw new TestSetFailedException(exception);
            }
        }
    }

    private static boolean isInsaneJunitNullString(String value) {
        return "null".equals(value);
    }
}

