/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.extensions.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CountDownLauncher {
    private final AtomicInteger countDown;

    public CountDownLauncher(int count) {
        if (count <= 0) {
            throw new IllegalStateException("count=" + count + " should be greater than zero");
        }
        this.countDown = new AtomicInteger(count);
    }

    protected abstract void job() throws IOException, InterruptedException;

    public void countDown() throws IOException, InterruptedException {
        if (this.countDown.decrementAndGet() == 0) {
            this.job();
        }
    }
}

