/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;

public class ProviderFactory {
    private final StartupConfiguration startupConfiguration;
    private final ProviderConfiguration providerConfiguration;
    private final ClassLoader surefireClassLoader;
    private final ClassLoader testsClassLoader;
    private final SurefireReflector surefireReflector;
    private final Object reporterManagerFactory;
    private static final Class[] invokeParamaters = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ProviderFactory.class$("java.lang.Object")) : class$java$lang$Object};
    static /* synthetic */ Class class$java$lang$Object;

    public ProviderFactory(StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Object reporterManagerFactory) {
        this.providerConfiguration = providerConfiguration;
        this.surefireClassLoader = surefireClassLoader;
        this.startupConfiguration = startupConfiguration;
        this.surefireReflector = new SurefireReflector(surefireClassLoader);
        this.testsClassLoader = testsClassLoader;
        this.reporterManagerFactory = reporterManagerFactory;
    }

    public SurefireProvider createProvider() {
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.surefireClassLoader);
        StartupConfiguration starterConfiguration = this.startupConfiguration;
        Object o = this.surefireReflector.createBooterConfiguration(this.surefireClassLoader, this.reporterManagerFactory);
        this.surefireReflector.setTestSuiteDefinitionAware(o, this.providerConfiguration.getTestSuiteDefinition());
        this.surefireReflector.setProviderPropertiesAware(o, this.providerConfiguration.getProviderProperties());
        this.surefireReflector.setReporterConfigurationAware(o, this.providerConfiguration.getReporterConfiguration());
        this.surefireReflector.setTestClassLoaderAware(o, this.surefireClassLoader, this.testsClassLoader);
        this.surefireReflector.setTestArtifactInfoAware(o, this.providerConfiguration.getTestArtifact());
        this.surefireReflector.setIfDirScannerAware(o, this.providerConfiguration.getDirScannerParams());
        Object provider = this.surefireReflector.instantiateProvider(starterConfiguration.getProviderClassName(), o);
        Thread.currentThread().setContextClassLoader(context);
        return new ProviderProxy(provider);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProviderProxy
    implements SurefireProvider {
        private final Object providerInOtherClassLoader;

        private ProviderProxy(Object providerInOtherClassLoader) {
            this.providerInOtherClassLoader = providerInOtherClassLoader;
        }

        public Iterator getSuites() {
            return (Iterator)ReflectionUtils.invokeGetter((Object)this.providerInOtherClassLoader, (String)"getSuites");
        }

        public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
            Method invoke = ReflectionUtils.getMethod(this.providerInOtherClassLoader.getClass(), (String)"invoke", (Class[])invokeParamaters);
            Object result = ReflectionUtils.invokeMethodWithArray((Object)this.providerInOtherClassLoader, (Method)invoke, (Object[])new Object[]{forkTestSet});
            return (RunResult)ProviderFactory.this.surefireReflector.convertIfRunResult(result);
        }

        public void cancel() {
            Method invoke = ReflectionUtils.getMethod(this.providerInOtherClassLoader.getClass(), (String)"cancel", (Class[])new Class[0]);
            ReflectionUtils.invokeMethodWithArray((Object)this.providerInOtherClassLoader, (Method)invoke, null);
        }
    }
}

